# Copyright © 2018-2023, Spillbox. All rights reserved.
# Property of Spillbox Inc.
# Any kind of copying or producing derivative work is prohibited without
# explicit written consent from Spillbox Inc.

locals {
  cidr_block        = "10.0.0.0/16"
  public_cidr_block = var.vpc_id == "" ? "10.0.1.0/24" : var.public_subnet_cidr == "" ? "10.0.1.0/24" : var.public_subnet_cidr
}

resource "google_compute_network" "vpc_main" {
  count                   = var.vpc_id == "" ? 1 : 0
  name                    = "${var.customer}-vpc"
  auto_create_subnetworks = false
  project                 = var.project
}

resource "google_compute_subnetwork" "subnet_public" {
  name          = "${var.customer}-public"
  ip_cidr_range = local.public_cidr_block
  network       = google_compute_network.vpc_main[0].self_link
  region        = var.region
}


resource "google_compute_router" "cluster_router" {
  project = var.project
  name    = "${var.customer}-router"
  region  = var.region
  network = google_compute_network.vpc_main[0].self_link
}
