# Copyright © 2018-2023, Spillbox. All rights reserved.
# Property of Spillbox Inc.
# Any kind of copying or producing derivative work is prohibited without
# explicit written consent from Spillbox Inc.

output "vpc_id" {
  description = "VPC id"
  value       = var.vpc_id == "" ? google_compute_network.vpc_main[0].id : var.vpc_id
}
output "subnet_public_id" {
  description = "Public subnet id"
  value       = google_compute_subnetwork.subnet_public.id
}

output "public_cidr_blocks" {
  description = "Public Network CIDR block"
  value       = [google_compute_subnetwork.subnet_public.ip_cidr_range]
}
