# Copyright © 2018-2023, Spillbox. All rights reserved.
# Property of Spillbox Inc.
# Any kind of copying or producing derivative work is prohibited without
# explicit written consent from Spillbox Inc.

terraform {
  required_version = ">= 1.10.4, < 1.10.5"
  required_providers {
    google = {
        version = "6.19.0"
    }
    null = {
        version = "3.2.3"
    }
    template = {
        version = "2.2.0"
    }
  }
  backend "gcs" {
    prefix = "states/nfs-machine"
  }
}

provider "google" {
  region      = var.region
  project     = var.project
  credentials = var.google_credentials
}

data "terraform_remote_state" "webserver" {
  backend = "gcs"

  config = {
    bucket = "ts-${var.customer}-${var.servername}"
    prefix = "states/webserver"
  }
}
module "splfs" {
  source                 = "../../google/compute_nvme/"
  number                 = var.min_nfs_count
  subnet_id              = data.terraform_remote_state.webserver.outputs.public_subnet_id
  customer               = "${var.customer}-${var.servername}"
  Name                   = var.servername
  key_name               = data.terraform_remote_state.webserver.outputs.key_name
  vpc_security_group_ids = [data.terraform_remote_state.webserver.outputs.public_security_group_id]
  ami_name               = var.spillbox_imageid
  instance_type          = var.nfs_instance_type == "" ? var.splfs_instance_type[var.model] : var.nfs_instance_type
  vm_user                = var.vm_user
  public_key             = var.project_public_key
  private_key            = var.project_private_key
  cloud_user             = var.cloud_user
  project                = var.project
  cache_dir              = var.cache_dir
  model                  = var.model
  data_in_memory         = var.data_in_memory
  dnsname                = data.terraform_remote_state.webserver.outputs.dnsname
  mountname              = data.terraform_remote_state.webserver.outputs.mountname
  zone                   = var.zone
  cloud_ssh_port         = var.cloud_ssh_port
  root_volume_size       = var.nfs_volume_size
  nfs_tag                = var.nfs_tag == "" ? "" : "${var.nfs_tag}"
  kms_key_id             = var.kms_key_id
servername          = var.servername
  project_public_key  = var.project_public_key
  spillbox_imageid    = var.spillbox_imageid
  compute_volume_size = var.compute_volume_size
}
