# Copyright © 2018-2023, Spillbox. All rights reserved.
# Property of Spillbox Inc.
# Any kind of copying or producing derivative work is prohibited without
# explicit written consent from Spillbox Inc.

variable "region" {
  description = "Region to deploy into"
}

variable "cloud_provider" {
  description = "Cloud provider name"
}

variable "customer" {
  description = "Customer or cluster name"
}

variable "vm_user" {
  description = "VM username which can configure the cluster"
}
variable "project" {}

variable "zone" {}

variable "google_credentials" {}

variable "enable_sgo" {}
variable "servername" {}
variable "nfs_instance_type" {}
variable "splfs_instance_type" {
  description = "Provides an EC2 instance resource for splfs server"
  type        = map(string)
  default = {
    small  = "c3-standard-8-lssd"
    medium = "c3-standard-8-lssd"
    large  = "c3-standard-8-lssd"
  }
}
variable "model" {
  description = "Provides the scale-model wanted for infrastructure"
}
variable "nfs_volume_size" {
  default = 50
}
variable "min_nfs_count" {}
variable "cache_dir" {}
variable "cloud_user" {}
variable "cloud_ssh_port" {}
variable "data_in_memory" {
  default = true
}
variable "webserver" {
  description = "A list containing private IP address "
  type        = list(string)
}
variable "compute" {}
variable "nfs" {}
variable "project_public_key" {}
variable "project_private_key" {}
variable "spillbox_imageid" {}
variable "nfs_tag" {}
variable "compute_volume_size" {
  description = "Size of the compute instance volume"
  type        = number
}
variable "kms_key_id" {}
