# Copyright © 2018-2023, Spillbox. All rights reserved.
# Property of Spillbox Inc.
# Any kind of copying or producing derivative work is prohibited without
# explicit written consent from Spillbox Inc.

resource "google_compute_firewall" "private" {
  name    = "${var.customer}-private"
  project = var.project
  network = var.public_id

  direction = "INGRESS"

  allow {
    protocol = "all"
  }

  source_ranges = concat(var.public_cidr_blocks[0])
}
resource "google_compute_firewall" "public_elb_ssh" {
  name    = "${var.customer}-public-elb-ssh"
  project = var.project
  network = var.public_id

  # SSH access from anywhere
  allow {
    ports    = [var.cloud_ssh_port]
    protocol = "tcp"
  }
  source_ranges = ["0.0.0.0/0"]
}
resource "google_compute_firewall" "private-outgoing" {
  name    = "${var.customer}-private-outgoing"
  project = var.project
  network = var.public_id

  direction = "EGRESS"

  allow {
    protocol = "all"
  }
}
