# Copyright © 2018-2023, Spillbox. All rights reserved.
# Property of Spillbox Inc.
# Any kind of copying or producing derivative work is prohibited without
# explicit written consent from Spillbox Inc.

terraform {
  required_version = ">= 1.10.4, < 1.10.5"
  required_providers {
    google = {
      version = "6.19.0"
    }
    local = {
      version = "2.5.2"
    }
    null = {
      version = "3.2.3"
    }
    tls = {
      version = "4.0.6"
    }
  }
}

provider "google" {
  region      = var.region
  project     = var.project
  credentials = var.google_credentials
}

module "backend" {
  count          = var.generate_ssh_key == true ? 1 : 0
  source         = "../storage/backend"
  backend_bucket = "ts-${var.customer}-${var.servername}"
}

locals {
  key_name = "${var.customer}-${var.servername}-auto-key"
  public_key_filename = format(
    "%s/%s-%s/%s%s",
    var.secrets,
    var.customer,
    var.servername,
    local.key_name,
    var.public_key_extension,
  )
  private_key_filename = format(
    "%s/%s-%s/%s%s",
    var.secrets,
    var.customer,
    var.servername,
    local.key_name,
    var.private_key_extension,
  )
  key_dir = format(
    "%s/%s-%s",
    var.secrets,
    var.customer,
    var.servername,
  )
}
/*
resource "google_compute_project_metadata_item" "imported" {
  count   = var.generate_ssh_key == false ? 1 : 0
  key     = local.key_name
  value   = file(local.public_key_filename)
  project = var.project
}
*/

module "tls_private_key" {
  source               = "../../../modules/ssh_key_pair"
  enabled              = var.generate_ssh_key == true ? 1 : 0
  public_key_filename  = local.public_key_filename
  private_key_filename = local.private_key_filename
}

resource "google_compute_project_metadata_item" "generated" {
  count   = var.generate_ssh_key == true ? 1 : 0
  key     = local.key_name
  value   = module.tls_private_key.public_key
  project = var.project
}

resource "google_compute_project_metadata" "generated" {
  count      = var.generate_ssh_key == true ? 1 : 0
  depends_on = [google_compute_project_metadata_item.generated]
  project    = var.project

  metadata = {
    block-project-ssh-keys = true
    ssh-keys               = <<EOF
${var.vm_user}:${replace(module.tls_private_key.public_key, "\n", "")} ${var.vm_user}@${var.customer}-${var.servername}
EOF

  }
}
