# Copyright © 2018-2023, Spillbox. All rights reserved.
# Property of Spillbox Inc.
# Any kind of copying or producing derivative work is prohibited without
# explicit written consent from Spillbox Inc.

output "key_name" {
  value = element(
    concat(
      compact(
        concat(
          google_compute_project_metadata_item.generated.*.key,
        ),
      ),
      [""],
    ),
    0,
  )
  description = "Name of SSH key"
}

output "public_key" {
  value = module.tls_private_key.public_key

  //value       = "${file("${local.public_key_filename}")}" 
  description = "Contents of the generated public key"
}

output "public_key_filename" {
  description = "Public Key Filename"
  value       = local.public_key_filename
}

output "private_key_filename" {
  description = "Private Key Filename"
  value       = local.private_key_filename
}


