# Copyright © 2018-2023, Spillbox. All rights reserved.
# Property of Spillbox Inc.
# Any kind of copying or producing derivative work is prohibited without
# explicit written consent from Spillbox Inc.

variable "region" {
  description = "Cloud provider region"
}

variable "cloud_provider" {
  description = "Cloud provider name"
}

variable "customer" {
  description = "Customer or cluster name"
}

variable "servername" {
  description = "Customer Server name"
}

variable "project" {
  description = "Customer Project ID"
}

variable "secrets" {
  type        = string
  description = "Path to SSH public key directory (e.g. `/secrets`)"
}

variable "generate_ssh_key" {
  type        = bool
  default     = true
  description = "If set to `true`, new SSH key pair will be created"
}

variable "ssh_key_algorithm" {
  type        = string
  default     = "RSA"
  description = "SSH key algorithm"
}

variable "private_key_extension" {
  type        = string
  default     = ".pem"
  description = "Private key extension"
}

variable "public_key_extension" {
  type        = string
  default     = ".pub"
  description = "Public key extension"
}

variable "chmod_command" {
  type        = string
  default     = "chmod 600 %v"
  description = "Template of the command executed on the private key file"
}

variable "vm_user" {
  description = "VM username which can configure the cluster"
}

variable "google_credentials" {
  description = "google credentials"
}

