# Copyright © 2018-2023, Spillbox. All rights reserved.
# Property of Spillbox Inc.
# Any kind of copying or producing derivative work is prohibited without
# explicit written consent from Spillbox Inc.

resource "google_storage_bucket" "tf_backend_bucket" {
  name          = var.backend_bucket
  location      = "US"
  force_destroy = true
  versioning {
    enabled = true
  }
  logging {
    log_bucket        = google_storage_bucket.tf_backend_logs_bucket.id
    log_object_prefix = "log/"
  }
}

resource "google_storage_bucket_acl" "tf_backend_bucket_acl" {
  bucket         = google_storage_bucket.tf_backend_bucket.name
  predefined_acl = "projectprivate"
}

resource "google_storage_bucket" "tf_backend_logs_bucket" {
  name          = "${var.backend_bucket}-logs"
  location      = "US"
  force_destroy = true
  versioning {
    enabled = true
  }
}

resource "google_storage_bucket_acl" "tf_backend_logs_bucket_acl" {
  bucket         = google_storage_bucket.tf_backend_logs_bucket.name
  predefined_acl = "projectprivate"
}


