# Copyright © 2018-2023, Spillbox. All rights reserved.
# Property of Spillbox Inc.
# Any kind of copying or producing derivative work is prohibited without
# explicit written consent from Spillbox Inc.

terraform {
  required_version = ">= 1.10.4, < 1.10.5"
  required_providers {
    google = {
        version = "6.19.0"
    }
    local = {
        version = "2.5.2"
    }
    null = {
        version = "3.2.3"
    }
    template = {
        version = "2.2.0"
    }
    tls = {
        version = "4.0.6"
    }
  }

  backend "gcs" {
    prefix = "states/webserver"
  }
}

provider "google" {
  region      = var.region
  project     = var.project
  credentials = var.google_credentials
}
module "subnet" {
  count              = var.enable_sgo == "false" ? 0 : var.subnet_id == "" ? 1 : 0
  source             = "../network/"
  region             = var.region
  project            = var.project
  customer           = "${var.customer}-${var.servername}"
  public_subnet_cidr = var.public_subnet_cidr
  vpc_id             = var.vpc_id
}


module "security_group" {
  count              = var.subnet_id == "" ? 1 : 0
  source             = "../security"
  public_cidr_blocks = [module.subnet[0].public_cidr_blocks]
  public_id          = var.vpc_id == "" ? module.subnet[0].vpc_id : var.vpc_id
  project            = var.project
  customer           = "${var.customer}-${var.servername}"
  cloud_ssh_port     = var.cloud_ssh_port
}

module "ssh_key_pair" {
  source             = "../ssh_key_pair"
  region             = var.region
  cloud_provider     = var.cloud_provider
  customer           = var.customer
  servername         = var.servername
  secrets            = var.secrets
  generate_ssh_key   = "false"
  vm_user            = var.vm_user
  project            = var.project
  google_credentials = var.google_credentials
}

resource "google_filestore_instance" "instance" {
  name     = "${var.customer}-${var.servername}"
  location = var.zone
  tier     = "BASIC_HDD"

  file_shares {
    capacity_gb = 1024
    name        = "shared"
  }

  networks {
    network = var.vpc_id == "" ? module.subnet[0].vpc_id : var.vpc_id
    modes   = ["MODE_IPV4"]
  }
}

module "webserver" {
  depends_on             = [google_filestore_instance.instance]
  count                  = var.enable_sgo == "false" ? 0 : 1
  source                 = "../../google/compute_fw"
  webserver_create       = var.webserver_create
  number                 = 1
  Name                   = "${var.servername}-hub"
  subnet_id              = var.subnet_id == "" ? module.subnet[0].subnet_public_id : var.subnet_id
  customer               = "${var.customer}-${var.servername}"
  key_name               = module.ssh_key_pair.key_name
  vpc_security_group_ids = var.subnet_id == "" ? [module.security_group[0].public_id] : []
  ami_name               = var.base_ami_name == "" ? "centos-7-v20240213" : var.base_ami_name
  instance_type          = var.webserver_instance_type == "" ? var.splpipe_instance_type[var.model] : var.webserver_instance_type
  vm_user                = var.vm_user
  project                = var.project
  public_key             = module.ssh_key_pair.public_key_filename
  private_key            = module.ssh_key_pair.private_key_filename
  zone                   = var.zone
  dnsname                = google_filestore_instance.instance.networks[0].ip_addresses[0]
  mountname              = "shared"
  cloud_ssh_port         = var.cloud_ssh_port
  root_volume_size       = var.webserver_volume_size
  docker_registry        = var.docker_registry
  docker_images          = var.docker_images
  service_userid         = var.service_userid
  kms_key_id             = var.kms_key_id
  spillbox_container     = var.spillbox_container
  singularity_sifpath    = var.singularity_sifpath
}
