# Copyright © 2018-2023, Spillbox. All rights reserved.
# Property of Spillbox Inc.
# Any kind of copying or producing derivative work is prohibited without
# explicit written consent from Spillbox Inc.

output "vpc_id" {
  value = var.vpc_id == "" ? module.subnet[0].vpc_id : var.vpc_id
}

output "public_subnet_id" {
  value = var.subnet_id == "" ? module.subnet[0].subnet_public_id : var.subnet_id
}


output "public_security_group_id" {
  value = var.subnet_id == "" ? module.security_group[0].public_id : "Not needed"
}
output "private_key" {
  value = module.ssh_key_pair.private_key_filename
}

output "public_key" {
  value = module.ssh_key_pair.public_key_filename
}
output "region" {
  value = var.region
}

output "cloud_ssh_port" {
  value = var.cloud_ssh_port
}
output "key_name" {
  value = module.ssh_key_pair.key_name
}
output "master_private_ip" {
  value = var.enable_sgo == "false" ? [[var.webserver[0]]] : module.webserver[0].private_ip
}

output "mountname" {
  value = "shared"
}

output "dnsname" {
  value = google_filestore_instance.instance.networks[0].ip_addresses[0]
}
output "vm_user" {
  value = var.vm_user
}
