# Copyright © 2018-2023, Spillbox. All rights reserved.
# Property of Spillbox Inc.
# Any kind of copying or producing derivative work is prohibited without
# explicit written consent from Spillbox Inc.

variable "region" {
  description = "Region to deploy into"
}

variable "cloud_provider" {
  description = "Cloud provider name"
}

variable "customer" {
  description = "Customer or cluster name"
}

variable "vm_user" {
  description = "VM username which can configure the cluster"
}
variable "secrets" {
  type        = string
  description = "Path to SSH public key directory (e.g. `/secrets`)"
}

variable "project" {}

variable "zone" {}

variable "google_credentials" {}

variable "enable_sgo" {}
variable "servername" {}

variable "public_subnet_cidr" {
  description = "Customer's public subnet CIDR"
}

variable "vpc_id" {
  description = "Customer's VPC id"
}
variable "subnet_id" {}
variable "security_group_id" {}
variable "cloud_ssh_port" {}
variable "webserver_instance_type" {}
variable "splpipe_instance_type" {
  description = "Provides an EC2 instance resource splpipe server"
  type        = map(string)
  default = {
    small  = "n2-standard-2"
    medium = "n2-standard-4"
    large  = "n2-standard-8"
  }
}
variable "model" {
  description = "Provides the scale-model wanted for infrastructure"
}
variable "base_ami_name" {}
variable "webserver_volume_size" {
  default = 50
}
variable "cloud_user" {}
variable "webserver" {
  description = "A list containing private IP address "
  type        = list(string)
  default     = null
}
variable "compute" {}
variable "nfs" {}
variable "docker_registry" {}
variable "docker_images" {}
variable "webserver_create" {}
variable "service_userid" {}
variable "kms_key_id" {}
variable "spillbox_container" {}
variable "singularity_sifpath" {}
