locals {
  compute_tag_map = merge(
    { Name = var.Name },
    var.compute_tag == "" ? {} : tomap({
      for item in [for pair in split(",", var.compute_tag) : split("=", pair)] : item[0] => item[1]
    })
  )
}

resource "oci_core_instance" "compute" {
  count                  = var.number
  compartment_id         = var.compartment_ocid
  availability_domain = var.zone
  shape                  = var.instance_type
  source_details {
    source_type = "image"
    source_id   = var.ami_name
    boot_volume_size_in_gbs = var.root_volume_size
    kms_key_id = var.kms_key_id == "" ? null : var.kms_key_id
  }
  create_vnic_details {
    subnet_id = var.subnet_id
  }
  display_name           = var.Name
  metadata = {
    ssh_authorized_key = file(var.public_key)
    instance_type = var.instance_type
  }
  preserve_boot_volume = false
  //dynamic "freeform_tags" {
    //for_each = var.compute_tag == "" ? [] : [local.compute_tag_map]

    //content {
    //  for key, value in defined_tags.value : key = value
    //}
  //}
  provisioner "local-exec" {
    command = "sleep ${var.wait_time_vm} && echo done waiting master VM ready"
  }
}

resource "null_resource" "fsx_client" {
  count = var.number
  connection {
    user        = var.vm_user
    private_key = file(var.private_key)
    host        = oci_core_instance.compute[count.index].public_ip
    port        = var.cloud_ssh_port
    timeout     = "600s"
  }
  provisioner "file" {
    source      = "${path.module}/install"
    destination = "/tmp"
  }

  provisioner "remote-exec" {
    inline = ["sudo chmod 755 /tmp/install/install.sh; sudo /tmp/install/install.sh"]
  }
}
