variable "number" {
  description = "Number of controller to deploy"
}
variable "ami_name" {}
variable "instance_type" {
  description = "EC2 instance resource"
}
variable "wait_time_vm" {
  description = "Wait time in second after VM up"
  default     = "180"
}
variable "subnet_id" {
  description = "VPC subnet id"
}
variable "security_group_id" {
  type        = list(any)
  description = "List of EC2 instance VPC security group resource ids"
}
variable "Name" {
  description = "EC2 Name tag"
}
variable "zone" {}
variable "vm_user" {}
variable "webserver_private_ip" {}
variable "private_key" {}
variable "public_key" {}
variable "mountname" {}
variable "dnsname" {}
variable "root_volume_size" {
  default     = "50"
  description = "The volume size for the root volume in GiB"
}
variable "cloud_ssh_port" {}
variable "compute_instance_type" {
  description = "Provides an EC2 instance resource for slurm master"
  type        = map(string)

  default = {
    small  = "t3.medium"
    medium = "t3.large"
    large  = "t3.xlarge"
  }
}
variable "compute_tag" {}
variable "kms_key_id" {}
variable "compartment_ocid" {}
