variable "number" {
  description = "Number of controller to deploy"
}

variable "ami_name" {
  description = "EC2 AMI resource"
}

variable "instance_type" {
  description = "EC2 instance resource"
}

variable "wait_time_vm" {
  description = "Wait time in second after VM up"
  default     = "180"
}

variable "subnet_id" {
  description = "VPC subnet id"
}

variable "vpc_security_group_ids" {
  type        = list(any)
  description = "List of EC2 instance VPC security group resource ids"
}

variable "Name" {
  description = "EC2 Name tag"
}

variable "customer" {
  description = "user-servertagname"
}

variable "zone" {
}

variable "public_key" {
}

variable "private_key" {
}

variable "vm_user" {
}

variable "EC2_ROOT_VOLUME_SIZE" {
  default     = "50"
  description = "The volume size for the root volume in GiB"
}

variable "EC2_ROOT_VOLUME_TYPE" {
  default     = "gp2"
  description = "The type of data storage: standard, gp2, io1"
}

variable "EC2_ROOT_VOLUME_DELETE_ON_TERMINATION" {
  default     = true
  description = "Delete the root volume on instance termination."
}
variable "cloud_ssh_port" {}
variable "mountname" {}
variable "dnsname" {}
variable "root_volume_size" {
  default     = "50"
  description = "The volume size for the root volume in GiB"
}
variable "docker_registry" {}
variable "docker_images" {}
variable "webserver_create" {}
variable "service_userid" {}
variable "kms_key_id" {}
variable "compartment_ocid" {}
variable "spillbox_container" {}
variable "singularity_sifpath" {}
