locals {
  nfs_tag_map = merge(
    { Name = var.Name },
    var.nfs_tag == "" ? {} : tomap({
      for item in [for pair in split(",", var.nfs_tag) : split("=", pair)] : item[0] => item[1]
    })
  )
}

resource "oci_core_instance" "instance" {
  count                  = var.number
  availability_domain = var.zone
  shape                  = var.instance_type
  compartment_id         = var.compartment_ocid
  source_details {
    source_type = "image"
    source_id   = var.ami_name
    boot_volume_size_in_gbs = var.root_volume_size
    kms_key_id = var.kms_key_id == "" ? null : var.kms_key_id
  }
  create_vnic_details {
    subnet_id = var.subnet_id
  }
  metadata = {
    ssh_authorized_keys = file(var.public_key)
    user_data = data.template_cloudinit_config.config.rendered
  }
  preserve_boot_volume = false
  display_name        = local.nfs_tag_map["Name"]
/*
  dynamic "freeform_tags" {
    for_each = var.nfs_tag == "" ? [] : [local.nfs_tag_map]

    content {
      for key, value in defined_tags.value : key = value
    }
  }
*/
}

resource "null_resource" "fsx_client" {
  count = var.number
  connection {
    user        = var.vm_user
    private_key = file(var.private_key)
    host        = oci_core_instance.instance[count.index].public_ip
    port        = var.cloud_ssh_port
    timeout     = "600s"
  }
  provisioner "file" {
    source      = "${path.module}/install"
    destination = "/tmp"
  }

  provisioner "remote-exec" {
    inline = ["sudo chmod 755 /tmp/install/install.sh; sudo /tmp/install/install.sh"]
  }
}

