variable "number" {
  description = "Number of controller to deploy"
}
variable "ami_name" {
  description = "EC2 AMI resource"
}
variable "instance_type" {
  description = "EC2 instance resource"
}
variable "wait_time_vm" {
  description = "Wait time in second after VM up"
  default     = "180"
}
variable "subnet_id" {
  description = "VPC subnet id"
}
variable "public_key" {}
variable "private_key" {}
variable "vpc_security_group_ids" {
  type        = list(string)
  description = "List of EC2 instance VPC security group resource ids"
}

variable "Name" {
  description = "EC2 Name tag"
}
variable "customer" {}
variable "model" {}
variable "cache_dir" {}
variable "zone" {}
variable "disk_size" {
  description = "size of local disk"
  type        = map(string)
  default = {
    small  = "470"
    medium = "3800"
    large  = "7200"
  }
}
variable "vm_user" {}
variable "cloud_user" {}
variable "data_in_memory" {
  type        = bool
  description = "File system in memory, not on disk"
}
variable "cloud_ssh_port" {}
variable "dnsname" {}
variable "project" {}
variable "mountname" {}
variable "root_volume_size" {
  default     = "50"
  description = "The volume size for the root volume in GiB"
}
variable "nfs_tag" {}
variable "kms_key_id" {}
variable "compartment_ocid" {}
