#!/bin/bash -f
#echo $1: vm_user  $2:master_private_ip 3:docker_registry 4:docker_images 5:service_account_id
CLOUD_USER="$1"
MASTER_IP="${2}"
DOCKER_REGISTRY=${3}
DOCKER_IMAGES=${4}
SERVICE_USERID="${5}"

centos=0
OSID=$(cat /etc/os-release | grep ^ID= | awk -F= '{print $2}' | sed 's/"//g')
CHRONYCONF="/etc/chrony/chrony.conf"
APT="apt-get"
if [[ -f /etc/centos-release ]] || [[ "$OSID" == "rhel" ]]; then
    APT=yum
    centos=1
    CHRONYCONF="/etc/chrony.conf"
    centos_version=$(rpm -E %{rhel})
    if [[ -f /etc/centos-release && ( "$centos_version" == "7" || "$centos_version" == "8" ) ]]; then
        sudo find /etc/yum.repos.d/ -type f -name '*.repo' -exec sed -i 's/mirror.centos.org/vault.centos.org/g' {} +
        sudo find /etc/yum.repos.d/ -type f -name '*.repo' -exec sed -i 's/^#.*baseurl=http/baseurl=http/g' {} +
        sudo find /etc/yum.repos.d/ -type f -name '*.repo' -exec sed -i 's/^mirrorlist=http/#mirrorlist=http/g' {} +
    fi
fi

echo enable chrony
sudo $APT remove -y ntp
sudo $APT install -y chrony
echo "server 169.254.169.123 prefer iburst" | sudo tee -a $CHRONYCONF
service_user="sbox"
if [ "$SERVICE_USERID" == "" ] ; then
    free_uid=$(awk -F: '{uid[$3]=1}END{for(x=2000;x<=10000;x++)if(!uid[x]){print x;exit}}' /etc/passwd /etc/group)
    sudo groupadd -g $free_uid $service_user
    sudo useradd -u $free_uid -g $free_uid $service_user
else
    uid=$(echo $SERVICE_USERID | awk -F ':' '{print $1}')
    gid=$(echo $SERVICE_USERID | awk -F ':' '{print $2}')
    service_user=$(echo $SERVICE_USERID | awk -F ':' '{print $3}')
    sudo groupadd -g $gid $service_user
    sudo useradd -u $uid -g $gid $service_user
fi

if test $centos -eq 1 ; then
    sudo $APT install -y bind-utils
    sudo /usr/sbin/chronyd
else
    sudo $APT install -y dnsutils
    sudo systemctl enable chrony
    sudo systemctl --no-pager start chrony
    sudo systemctl --no-pager status chrony
fi
sudo chronyc makestep
if ! timedatectl | grep -q "synchronized: yes" ; then
    PID=$( ps aux | grep -v grep | grep /usr/sbin/chronyd | awk '{print $2}')
    if [ "${PID}" != "" ]; then
        sudo kill -9 $PID
    fi
    sleep 10
    sudo /usr/sbin/chronyd
    sudo chronyc makestep
fi
sudo systemctl stop firewalld.service

if test $centos -eq 1 ; then
    sudo yum update -y
    sudo yum install -y bind-utils
    sudo yum install -y libnsl
    sudo yum install -y wget
    if [ "$OSID" == "rhel" ]; then
        rhel_version=$(rpm -E %{rhel})
        wget -P /tmp https://dl.fedoraproject.org/pub/epel/epel-release-latest-${rhel_version}.noarch.rpm
        sudo yum install -y /tmp/epel-release-latest-${rhel_version}.noarch.rpm
    else
        sudo yum install -y epel-release
    fi
    sudo yum install -y yum-utils nfs-utils
    sudo yum install -y vim patchelf jq ed java-1.8.0-openjdk-devel jo
    sudo service rpc-statd start
    sudo systemctl enable rpc-statd
    #Providing sudo power to user and setting no passwd
    sudo usermod -aG wheel $service_user
    echo "${service_user} ALL=(ALL) NOPASSWD:ALL" | sudo tee -a /etc/sudoers.d/99_sudouser
else
    sudo apt-get update -y
    sudo apt-get install -y  dnsutils
    sudo apt install -y vim patchelf wget jq
    sudo apt-get install -y  ca-certificates curl gnupg
    #Providing sudo power to user and setting no passwd
    sudo usermod -aG sudo $service_user
    echo "${service_user} ALL=(ALL) NOPASSWD:ALL" | sudo tee -a /etc/sudoers.d/99_sudouser
fi

sudo bash -c 'cat <<END >> /etc/security/limits.conf
*                soft    nproc           65536
*                hard    nproc           65536
*                soft    nofile          1024000
*                hard    nofile          1024000
END'


#removing host from /etc/hosts
hostname=$(hostname)
sudo sed -i "/${hostname}/d" /etc/hosts
