#!/bin/bash -f

echo "Create a temporary symbolic link to retrieve UUID on first boot"

timeout_duration=600
time_done=0
LINK_CREATED="false"

while [ "$LINK_CREATED" == "false" ] && [ $time_done -lt $timeout_duration ]; do
    VOLUMES_NAME=$(find /dev | grep -i 'nvme[0-21]n1$')
    if [ -z "$VOLUMES_NAME" ]; then
        VOLUMES_NAME=$(find /dev | grep -i 'xvdf')
        if [ "$VOLUMES_NAME" != ""  ]; then
            LINK_CREATED="true"
        fi
        echo "Timeout: VOLUMES_NAME not populated within $timeout_duration seconds."
    else
        echo "$VOLUMES_NAME" | tr " " "\n"
        for VOLUME in $VOLUMES_NAME; do
            ALIAS=$(nvme id-ctrl -v "$VOLUME" | grep -Po '/dev/xvdf')
            if [ ! -z "$ALIAS" ]; then
                echo "---> Create link from $VOLUME to $ALIAS"
                ln -s "$VOLUME" "$ALIAS"
                LINK_CREATED="true"
            fi
        done
        sleep 10
        ((time_done += 10))
    fi
done

