terraform {
  required_version = ">= 1.10.4, < 1.10.5"

  backend "s3" {
    skip_region_validation      = true
    skip_credentials_validation = true
    skip_metadata_api_check     = true
    force_path_style            = true
    key     = "states/job_machine"
    encrypt = true
  }
}

provider "oci" {
  region          = var.region
  tenancy_ocid    = var.tenancy_ocid
  user_ocid       = var.user_ocid
  fingerprint     = var.fingerprint
  private_key_path = var.private_key_path
}

data "terraform_remote_state" "webserver" {
  backend = "s3"

  config = {
    bucket = "ts-${var.customer}-${var.servername}"
    region = var.region
    skip_region_validation      = true
    skip_credentials_validation = true
    skip_metadata_api_check     = true
    force_path_style            = true
    key    = "states/webserver"
  }
}

module "job_machine" {
  count  = var.enable_sgo == "false" ? 0 : 1
  source = "../../oci/compute/"
  number               = var.min_compute_count
  instance_type       = "VM.Standard.E2.2" #var.compute_instance_type == "" ? var.job_instance_type[var.model] : var.compute_instance_type
  ami_name             = var.spillbox_imageid
  subnet_id            = data.terraform_remote_state.webserver.outputs.public_subnet_id
  webserver_private_ip = data.terraform_remote_state.webserver.outputs.master_private_ip
  security_group_id   = [data.terraform_remote_state.webserver.outputs.public_security_group_id]
  Name         = "${var.servername}-job"
  private_key          = data.terraform_remote_state.webserver.outputs.private_key
  vm_user            = var.vm_user
  public_key         = data.terraform_remote_state.webserver.outputs.public_key
  cloud_ssh_port             = var.cloud_ssh_port
  dnsname             = data.terraform_remote_state.webserver.outputs.dnsname
  mountname         = data.terraform_remote_state.webserver.outputs.mountname
  root_volume_size     = var.compute_volume_size
  compute_tag                 = var.compute_tag == "" ? "" : "${var.compute_tag}"
  kms_key_id           = var.kms_key_id
  zone                 = var.zone
  compartment_ocid  = var.compartment_ocid
}

