terraform {
  required_version = ">= 1.10.4, < 1.10.5"

  backend "s3" {
    skip_region_validation      = true
    skip_credentials_validation = true
    skip_metadata_api_check     = true
    force_path_style            = true
    key     = "states/nfs_machine"
    encrypt = true
  }
}

provider "oci" {
  region          = var.region
  tenancy_ocid    = var.tenancy_ocid
  user_ocid       = var.user_ocid
  fingerprint     = var.fingerprint
  private_key_path = var.private_key_path
}

data "terraform_remote_state" "webserver" {
  backend = "s3"

  config = {
    bucket = "ts-${var.customer}-${var.servername}"
    region = var.region
    skip_region_validation      = true
    skip_credentials_validation = true
    skip_metadata_api_check     = true
    force_path_style            = true
    key    = "states/webserver"
  }
}

module "splfs" {
  count                  = var.enable_sgo == "false" ? 0 : 1
  source                 = "../../oci/compute_nvme"
  number                 = var.min_nfs_count
  Name                   = "${var.servername}-nfs"
  subnet_id              = data.terraform_remote_state.webserver.outputs.public_subnet_id
  customer               = "${var.customer}-${var.servername}"
  vpc_security_group_ids = [data.terraform_remote_state.webserver.outputs.public_security_group_id]
  ami_name               = var.spillbox_imageid
  instance_type             = "VM.Standard.E2.2" #var.nfs_instance_type == "" ? var.splfs_instance_type[var.model] : var.nfs_instance_type
  vm_user                   = var.vm_user
  public_key             = data.terraform_remote_state.webserver.outputs.public_key
  private_key            = data.terraform_remote_state.webserver.outputs.private_key
  cloud_user             = var.cloud_user
  project                = "not needed for aws"
  cache_dir              = var.cache_dir
  model                  = var.model
  data_in_memory         = var.data_in_memory
  dnsname               = data.terraform_remote_state.webserver.outputs.dnsname
  kms_key_id             = var.kms_key_id
  mountname           = data.terraform_remote_state.webserver.outputs.mountname
  zone    = var.zone
  cloud_ssh_port               = var.cloud_ssh_port
  root_volume_size       = var.nfs_volume_size
  nfs_tag                = var.nfs_tag == "" ? "" : "${var.nfs_tag}"
  compartment_ocid      = var.compartment_ocid
}

