terraform {
  required_version = ">= 1.10.4, < 1.10.5"
}

provider "oci" {
  region          = var.region
  tenancy_ocid    = var.tenancy_ocid
  user_ocid       = var.user_ocid
  fingerprint     = var.fingerprint
  private_key_path = var.private_key_path
}

module "backend" {
  source                      = "../storage/backend"
  create                      = var.generate_ssh_key == true ? 1 : 0
  backend_bucket              = "ts-${var.customer}-${var.servername}"
  oci_namespace               = var.oci_namespace
  compartment_id              = var.compartment_ocid
}

locals {
  key_name = "${var.customer}-${var.servername}-auto-key"
  public_key_filename = format(
    "%s/%s-%s/%s%s",
    var.secrets,
    var.customer,
    var.servername,
    local.key_name,
    var.public_key_extension,
  )
  private_key_filename = format(
    "%s/%s-%s/%s%s",
    var.secrets,
    var.customer,
    var.servername,
    local.key_name,
    var.private_key_extension,
  )
  key_dir = format(
    "%s/%s-%s",
    var.secrets,
    var.customer,
    var.servername,
  )
}

module "tls_private_key" {
  source               = "../../../modules/ssh_key_pair"
  enabled              = var.generate_ssh_key == true ? 1 : 0
  public_key_filename  = local.public_key_filename
  private_key_filename = local.private_key_filename
}
