terraform {
  required_version = ">= 1.10.4, < 1.10.5"
  backend "s3" {
    skip_region_validation      = true
    skip_credentials_validation = true
    skip_metadata_api_check     = true
    force_path_style            = true
    key = "states/webserver"
  }
}

provider "oci" {
  region          = var.region
  tenancy_ocid    = var.tenancy_ocid
  user_ocid       = var.user_ocid
  fingerprint     = var.fingerprint
  private_key_path = var.private_key_path
}
module "ssh_key_pair" {
  source           = "../ssh_key_pair"
  region           = var.region
  secrets          = var.secrets
  cloud_provider   = var.cloud_provider
  customer         = var.customer
  servername       = var.servername
  generate_ssh_key = "false"
  tenancy_ocid    = var.tenancy_ocid
  user_ocid       = var.user_ocid
  fingerprint     = var.fingerprint
  private_key_path = var.private_key_path
  oci_namespace = var.oci_namespace
  compartment_ocid = var.compartment_ocid
}
//data "oci_identity_tenancy" "tenancy" {}

//resource "oci_identity_compartment" "compartment" {
//  compartment_id = oci_identity_tenancy.tenancy.id
//  name           = var.customer
//}
data "oci_identity_availability_domains" "check" {
  compartment_id = var.compartment_ocid
}

resource "oci_file_storage_file_system" "shared" {
  compartment_id = var.compartment_ocid
  display_name   = "${var.customer}-${var.servername}"
//  availability_domain = lookup(data.oci_identity_availability_domains.check.availability_domains[0], "name")
    availability_domain = var.zone
}
resource "oci_file_storage_mount_target" "mount_target" {
 // availability_domain = lookup(data.oci_identity_availability_domains.check.availability_domains[0], "name")
 availability_domain = var.zone
  compartment_id      = var.compartment_ocid
  subnet_id           = var.subnet_id
  display_name        = "${var.customer}-${var.servername}"
}

resource "oci_file_storage_export_set" "export_set" {
  mount_target_id     = oci_file_storage_mount_target.mount_target.id
  display_name        = "${var.customer}-${var.servername}"
}

resource "oci_file_storage_export" "export" {
  export_set_id       = oci_file_storage_export_set.export_set.id
  file_system_id      = oci_file_storage_file_system.shared.id
  path                = "/fsx_shared"

  export_options {
    source           = "0.0.0.0/0"  # Allow access from all IPs (modify this as needed)
    access           = "READ_WRITE"
    identity_squash  = "NONE"
  }
}

module "webserver" {
  depends_on            = [oci_file_storage_file_system.shared]
  count                 = var.enable_sgo == "false" ? 0 : 1
  source                = "../../oci/compute_fw/"
  webserver_create      = var.webserver_create
  number                = "1"
  Name                  = "${var.servername}-hub"
  subnet_id             = var.subnet_id
  customer              = "${var.customer}-${var.servername}"
  ami_name              = var.base_ami_name
  instance_type         = var.webserver_instance_type == "" ? var.splpipe_instance_type[var.model] : var.webserver_instance_type
  cloud_ssh_port        = var.cloud_ssh_port
  vm_user               = var.vm_user
  root_volume_size      = var.webserver_volume_size
  docker_registry       = var.docker_registry
  docker_images         = var.docker_images
  service_userid        = var.service_userid
  zone                  = var.zone
  kms_key_id            = var.kms_key_id 
  public_key            = module.ssh_key_pair.public_key_filename
  private_key           = module.ssh_key_pair.private_key_filename
  mountname             = "Not needed"
  dnsname               = "Not needed"
  vpc_security_group_ids = ["Not Needed"]
  compartment_ocid      = var.compartment_ocid
  spillbox_container     = var.spillbox_container
  singularity_sifpath    = var.singularity_sifpath
}
