variable "region" {
  description = "Region to deploy into"
}

variable "cloud_provider" {
  description = "Cloud provider name"
}

variable "customer" {
  description = "Customer or cluster name"
}

variable "servername" {
  description = "Server Tag name"
}

variable "splpipe_instance_type" {
  description = "Provides an EC2 instance resource splpipe server"
  type        = map(string)
 default = {
    small  = "VM.Standard3.1"
    medium = "VM.Standard3.2"
    large  = "VM.Standard3.4"
  }
}

variable "model" {
  description = "Provides the scale-model wanted for infrastructure"
}


variable "secrets" {
  type        = string
  description = "Path to SSH public key directory (e.g. `/secrets`)"
}


variable "base_ami_name" {
  description = "Provide full name of SPLPIPE ami present in AWS "
}


variable "data_in_memory" {
  type        = bool
  description = "File system in memory, not on disk"
}

variable "vpc_id" {
  description = "Customer's VPC id"
}

variable "public_subnet_cidr" {
  description = "Customer's public subnet CIDR"
}

variable "cloud_ssh_port" {}
variable "subnet_id" {}
variable "security_group_id" {}
variable "vm_user" {}
variable "cache_dir" {}
variable "cloud_user" {}
variable "enable_sgo" {}
variable "nfs_instance_type" {}
variable "webserver_instance_type" {}
variable "webserver_volume_size" {}
variable "nfs_volume_size" {}
variable "webserver" {
  description = "A list containing private IP address "
  type        = list(string)
  default     = null
}
variable "compute" {}
variable "nfs" {}
variable "docker_registry" {}
variable "docker_images" {}
variable "webserver_create" {}
variable "service_userid" {}
variable "kms_key_id" {}
variable "compartment_ocid" {}
variable "oci_namespace" {}
variable "tenancy_ocid" {}
variable "user_ocid" {}
variable "fingerprint" {}
variable "private_key_path" {}
variable "zone" {}
variable "spillbox_container" {}
variable "singularity_sifpath" {}
