#!/bin/bash -fx

# Copyright © 2018-2023, Spillbox. All rights reserved.
# Property of Spillbox Inc.
# Any kind of copying or producing derivative work is prohibited without
# explicit written consent from Spillbox Inc.
#1: newlog_file_path 2:cachesize

NEW_LOGFILE="$1"
CACHE_SIZE="${2}"

if [[ "$PROJECT_INFO" == "" ]]; then
    echo "PROJECT_INFO not set " >&2
    exit 3
else
    source $PROJECT_INFO
fi
ADDUSEROPTION="--gecos GECOS --disabled-password"
ADDGROUP="addgroup"

if [[ -f /etc/centos-release || -f /etc/redhat-release ]] ; then
        centos=1
        ADDGROUP="groupadd"
        ADDUSEROPTION=""
fi
sudo $ADDGROUP -f --gid $SPILLBOX_CLOUD_GID $SPILLBOX_CLOUD_GROUP 
sudo id -u $SPILLBOX_CLOUD_USER >& /dev/null || sudo adduser --no-create-home --uid $SPILLBOX_CLOUD_UID --gid $SPILLBOX_CLOUD_GID $ADDUSEROPTION $SPILLBOX_CLOUD_USER 

PORT=2049
MOUNTPORT=0
if [ "$SPILLBOX_SPLFS_PORT" != "0" ] ; then
    PORT=$SPILLBOX_SPLFS_PORT
fi
if [ "$SPILLBOX_SPLFS_MOUNTPORT" != "0" ] ; then
    MOUNTPORT=$SPILLBOX_SPLFS_MOUNTPORT
fi

function random_ip() {
    local available_ip=$1
    local random_ip
    if [[ "$available_ip" != "" ]]; then
        IFS=',' read -ra ip <<< "$available_ip"
        length=${#ip[@]}
        if [[ $length -gt 1 ]]; then
            index=$((RANDOM % length))
            random_ip=${ip[index]}
            echo $random_ip
        else
            echo $available_ip
        fi
    
    fi
}

if [ "$SPILLBOX_CLOUD_PROVIDER" == "" ]; then
    SEP=','
    if [[ "$SPILLBOX_CONTAINER" == "singularity" || "$SPILLBOX_CONTAINER" == "host" ]] ; then
        SEP=':'
    fi
    IFS=$SEP read -ra ADDR <<< "$SPILLBOX_MOUNT_PATHS"
    for i in "${ADDR[@]}"; do
        sudo mkdir -p $i
        sudo mount -o fg,hard,noatime,nodiratime,rsize=1048576,wsize=1048576,timeo=600,vers=4,port=$PORT,mountport=$MOUNTPORT ${SPILLBOX_SPLFS_SERVER}:${SPILLBOX_CACHE_DIR}/${SPILLBOX_CUSTOMER}/cache_dir/data$i$i $i
    done
else
    mountpath=$(echo $SPILLBOX_MOUNT_PATHS | tr ":" "\n")
    for apath in $mountpath
    do
        mkdir -p $apath
        chmod 755 $apath
        ip=$(random_ip $SPILLBOX_SPLFS_SERVER)
        sudo mount -t nfs4 -o hard,async,intr $ip:$SPILLBOX_CACHE_DIR/$SPILLBOX_CUSTOMER/cache_dir/data$apath$apath $apath 
        status=$?
        if [ "$status" != "0" ] ; then
            echo "Mount of $apath failed" >&2
        fi
    done
fi

$TERRAFORM_ROOT/predictivecache/splpred  --setolf $TERRAFORM_ROOT/predictivecache/old_log --setnlf ${NEW_LOGFILE} --cachesize $CACHE_SIZE

