#!/bin/bash -fx

# Copyright © 2018-2023, Spillbox. All rights reserved.
# Property of Spillbox Inc.
# Any kind of copying or producing derivative work is prohibited without
# explicit written consent from Spillbox Inc. 
usage()
{
    echo "Usage : $0 aws|google|azure|local predictivecache|destroycluster  <customer>  <project_name> -logfile <spillbox_log_file> -cachesize <cachesize>"
}

DIR=$(realpath $TERRAFORM_ROOT)
SPILLBOX_CLOUD_USER="$3"
SPILLBOX_PROJECT="$4"
if [ "$1" == "local" ] ; then
    if [ "$SPILLBOX_SITE" == "" ] ; then
        echo "SPILLBOX_SITE not set"  >& 2
        exit 3
    fi
    spillbox_config_file=$(realpath $DIR/etc/spillbox_config)
    if [ -f  $spillbox_config_file ]; then
        . $spillbox_config_file
    else
        echo missing config file : $spillbox_config_file >&2
        exit 3
    fi
    if [[ "$runtime_container" == "docker" ]]; then
        if [ "$docker_path" == "" ]; then 
            docker_path=$(which docker)
        fi 
        IMAGE=${docker_base_image}
    elif [[ "$runtime_container" == "singularity" ]]; then
         if [ "$singularity_path" == "" ]; then
            singularity_path=$(which singularity)
        fi
        IMAGE=${singularity_base_image}
    fi
else
    docker_path="docker"
fi
CONTAINER_NAME="$SPILLBOX_CLOUD_USER-$SPILLBOX_PROJECT-pred"
if [ "$2" == "destroycluster" ]; then
    if [ "$1" == "local" ] ; then
        if [ "$runtime_container" == "docker" ]; then 
            $docker_path rm -f "$CONTAINER_NAME"
        elif [ "$runtime_container" == "singularity" ]; then 
            echo "kill singularity container..."
        fi
        exit 0
    else
        docker rm -f "$CONTAINER_NAME"
    fi
fi

#Removing existing old  conatiner
if docker ps -a --format '{{.Names}}' | grep -q "^${CONTAINER_NAME}$"; then
    echo "Removing container: $CONTAINER_NAME"
    docker rm -f "$CONTAINER_NAME"
fi

# copy the log file from /tmp to nfs log area
cp $6 $DIR/predictivecache/old_log
CACHE_SIZE=${8}

#creating containers
if [ "$1" == "local" ]; then
    export PROJECT_INFO="${workdir}/.spillbox/sites/local/${SPILLBOX_SITE}/sites/local/customers/conf/${SPILLBOX_CLOUD_USER}-${SPILLBOX_PROJECT}"
#    export PROJECT_MOUNTINFO="${workdir}/.spillbox/sites/local/${SPILLBOX_SITE}/sites/local/customers/mount_paths/${SPILLBOX_CLOUD_USER}-${SPILLBOX_PROJECT}"
    if [[ "$runtime_container" == "docker" ]]; then
         $docker_path run --rm --net=host --ulimit nofile=655360:655360 $nofile_unlimit --pids-limit 65536 --privileged -d -v ${workdir}/.spillbox:${workdir}/.spillbox -e PROJECT_INFO=$PROJECT_INFO -e TERRAFORM_ROOT=$DIR --entrypoint ${workdir}/.spillbox/sites/local/${SPILLBOX_SITE}/terraform/predictivecache/entrypoint.sh --name="$SPILLBOX_CLOUD_USER-$SPILLBOX_PROJECT-pred" $IMAGE $TERRAFORM_ROOT/stacks/modules/docker-nfs/install/spillbox_splfs/LOG/spillbox_file.log $CACHE_SIZE
    elif [[ "$runtime_container" == "singularity" ]]; then
         sudo $singularity_path exec --writable-tmpfs  --pids-limit 65536 -B ${workdir}/.spillbox:${workdir}/.spillbox  --env PROJECT_INFO=$PROJECT_INFO --env PROJECT_INFO=$PROJECT_INFO --env TERRAFORM_ROOT=$DIR $IMAGE ${workdir}/.spillbox/sites/local/${SPILLBOX_SITE}/terraform/predictivecache/entrypoint.sh $TERRAFORM_ROOT/stacks/modules/docker-nfs/install/spillbox_splfs/LOG/spillbox_file.log $CACHE_SIZE
    fi
else
   export PROJECT_INFO="/opt/spillbox/splfs/etc/ganesha/setup.sh"
    $docker_path run --rm --net=host --ulimit nofile=655360:655360 $nofile_unlimit --pids-limit 65536 --privileged -d -v $DIR:$DIR -v /opt/spillbox/splfs:/opt/spillbox/splfs  -v /var/log/spillbox_file.log:/var/log/spillbox_file.log -e PROJECT_INFO=$PROJECT_INFO -e TERRAFORM_ROOT=$DIR -e CACHE_SIZE=$CACHE_SIZE --entrypoint ${DIR}/predictivecache/entrypoint.sh --name="$SPILLBOX_CLOUD_USER-$SPILLBOX_PROJECT-pred" spillbox_snapshot /var/log/spillbox_file.log $CACHE_SIZE
fi
