#!/bin/bash -f

# Copyright © 2018-2023, Spillbox. All rights reserved.
# Property of Spillbox Inc.
# Any kind of copying or producing derivative work is prohibited without
# explicit written consent from Spillbox Inc.

# Wrapper Script for Executing Terraform
#

usage()
{
    echo "Usage : $0 [-kill] aws|google|azure" >&2
}

timesynced=$(timedatectl |& grep "synchronized:" | awk -F":" '{print $2}' | sed 's/ //g')
if [ "$timesynced" == "no" ]; then
    echo "System Clock not synchronized." >&2
    exit 3
fi

host=$(/bin/hostname -i)
DIR="$( cd "$( dirname "${BASH_SOURCE[0]}" )" >/dev/null 2>&1 && pwd )"
WDIR=$HOME
SPILLBOX_SITE=$(grep ^SPILLBOX_SITE $DIR/SPILLBOX_SITE_INFO | awk -F= '{print $2}' | sed -e 's/^"//' -e 's/"$//' | sed 's/ //g')
export SPLPIPE_BUCKET=$(grep ^SPLPIPE_BUCKET $DIR/SPILLBOX_SITE_INFO | awk -F= '{print $2}' | sed -e 's/^"//' -e 's/"$//' | sed 's/ //g')
export SPLFS_BUCKET=$(grep ^SPLFS_BUCKET $DIR/SPILLBOX_SITE_INFO | awk -F= '{print $2}' | sed -e 's/^"//' -e 's/"$//' | sed 's/ //g')
export SPLINFRA_BUCKET=$(grep ^SPLINFRA_BUCKET $DIR/SPILLBOX_SITE_INFO | awk -F= '{print $2}' | sed -e 's/^"//' -e 's/"$//' | sed 's/ //g')

if test "$#" -lt 1; then
    usage;
    exit 3
fi

EXE="spld"
CLOUD=""

case "$1" in
-kill)
    if test "$#" -lt 2; then
        usage;
        exit 3
    fi
    if pgrep -f "${EXE}" >/dev/null
    then
        PID=`pgrep -f "${EXE}"`
        echo "killing ${EXE} pid $PID"
        pkill -9 -f ${EXE}
    else
        host=$(hostname)
        echo "No server running on host $host. Please check if you are on correct host."
    fi
    exit 0
    ;;
 aws)
    CLOUD=$1
    if [[ -z "$AWS_ACCESS_KEY_ID" || -z "$AWS_SECRET_ACCESS_KEY" ]]; then
        echo "Cloud Crendentials missing" 2>&1 | tee /dev/stderr
        exit 3
    fi
    ;;
 google)
    CLOUD=$1
    if [[ -z "$GOOGLE_PROJECT" || -z "$GOOGLE_APPLICATION_CREDENTIALS" ]]; then
        echo "Cloud Crendentials missing" 2>&1 | tee /dev/stderr
        exit 3
    fi
    ;;
 azure)
    CLOUD=$1
    if [[ -z "$ARM_CLIENT_ID" || -z "$ARM_CLIENT_SECRET" || -z "$ARM_SUBSCRIPTION_ID" || -z "$ARM_TENANT_ID"  ]]; then
        echo "Cloud Crendentials missing" 2>&1 | tee /dev/stderr
        exit 3
    fi
    if [ -z "$TF_VAR_sig_cloud_id" ]; then
        echo "Cloud Crendential TF_VAR_sig_cloud_id for image gallery missing" 2>&1 | tee /dev/stderr
        exit 3
    fi
    if [ -z "$TF_VAR_sig_cloud_key" ]; then
        echo "Cloud Crendential TF_VAR_sig_cloud_key for image gallery missing" 2>&1 | tee /dev/stderr
        exit 3
    fi
    export ARM_USE_MSI=true
    ;;
 *)
    usage;
    exit 3
    ;;
esac 

if pgrep -f "${EXE}" >/dev/null
then
    PID=`pgrep -f "${EXE}"`
    echo "killing ${EXE} pid $PID"
    pkill -9 -f ${EXE}
fi

INSTALL="$DIR/stacks/modules/splpipe/install"
( cd $DIR/stacks/provider; /bin/rm -f current ; ln -s $CLOUD current)
( cd $DIR/stacks/provider/$CLOUD/ssh_key_pair/ ; ../../../../bin/terraform init > /dev/null)
( cd $DIR/stacks/provider/$CLOUD/splfs/ ; ../../../../bin/terraform init > /dev/null)
if [ "$CLOUD" == "google" ]; then
    ( cd $DIR/stacks/provider/$CLOUD/project/ ; ../../../../bin/terraform init > /dev/null)
fi
if [ "$CLOUD" == "azure" ]; then
    ( cd $DIR/stacks/provider/$CLOUD/resource_group/ ; ../../../../bin/terraform init > /dev/null)
fi
( cd $DIR/stacks/provider/$CLOUD/spillbox-cluster/ ; ../../../../bin/terraform init > /dev/null)

cat > $WDIR/spld.toml <<EOF
[server]

port = 8000
cli  = false

[infra]

control = true
root = "$DIR"
cloud = "$CLOUD"
siteid = "$SPILLBOX_SITE" 

[clients]

#ip =

EOF

(cd $INSTALL; cp auth_model.conf policy.csv spld $WDIR/.)
(cd $WDIR; /bin/rm -f nohup.out; nohup ./spld --config-file spld.toml >& $WDIR/log &)
exit 0
