#!/bin/bash -f

# Copyright © 2018-2023, Spillbox. All rights reserved.
# Property of Spillbox Inc.
# Any kind of copying or producing derivative work is prohibited without
# explicit written consent from Spillbox Inc.

DIR=$(realpath $(dirname $0)) 
spillbox_setup_file=$(realpath $DIR/setup.sh)
if [ -f  $spillbox_setup_file ]; then 
    . $spillbox_setup_file
else
    echo missing setup file : $spillbox_setup_file >&2
    exit 3
fi

ADDUSEROPTION="--gecos GECOS --disabled-password"
ADDGROUP="addgroup"

if [ -f /etc/centos-release ] ; then
        centos=1
        ADDGROUP="groupadd"
        ADDUSEROPTION=""
fi
if [ "$SPILLBOX_CLOUD_GID" == "" ] ; then
    echo "Environment variables are not exported. Please export." >&2
    exit 3
fi
sudo $ADDGROUP -f --gid $SPILLBOX_CLOUD_GID $SPILLBOX_CLOUD_GROUP 
sudo id -u $SPILLBOX_CLOUD_USER >& /dev/null || sudo adduser --no-create-home --uid $SPILLBOX_CLOUD_UID --gid $SPILLBOX_CLOUD_GID $ADDUSEROPTION $SPILLBOX_CLOUD_USER 

SEP=','
if [[ "$SPILLBOX_CONTAINER" == "singularity" || "$SPILLBOX_CONTAINER" == "host" ]] ; then
    SEP=':'
fi

IFS=$SEP read -ra ADDR <<< "$SPILLBOX_LINK_PATHS"
for i in "${ADDR[@]}"; do
    src=$(echo $i | awk -F: '{print $1}')
    dst=$(echo $i | awk -F: '{print $2}')
    if [ "$src" != "" ]; then
        if [ "$dst" != "" ]; then
            if [[ ! -L "$src" ]]; then
                sudo ln -s $dst $src
            fi
        fi
    fi
done

exec sudo --preserve-env=PATH -E -u  $SPILLBOX_CLOUD_USER --  "$@"
