# Copyright © 2018-2023, Spillbox. All rights reserved.
# Property of Spillbox Inc.
# Any kind of copying or producing derivative work is prohibited without
# explicit written consent from Spillbox Inc.

locals {
  rm_arg = var.docker_rm ? "--rm" : ""
  image_name     = "${var.customer}-compute"
  derived_image  =  var.disable_docker_image? var.docker_base_image : "${var.customer}-compute"
  container_name = "${var.customer}-global-cache"
  registry_name = var.disable_docker_image? "${var.docker_host}:${var.docker_registry_port}/${var.server_image}" : "${var.docker_host}:${var.docker_registry_port}/${var.customer}-compute"
  cwd            = abspath(path.module)
  container_mount_path = var.container == "host"? "${local.cwd}/install/spillbox_cluster" : "/spillbox_cluster"
  cache_dir      = var.cache_dir == ""? var.container == "host"? "/dev/shm" : var.container == "singularity"? "/spillbox_cachedir" : "/dev/shm" : var.cache_dir
}

resource "null_resource" "build_image" {
  count     = var.container == "singularity" ? 0 : var.container == "host" ? 0 : var.disable_docker_image? 0 : 1
  provisioner "local-exec" {
    command = "(cd ${path.module}/install; ${var.docker_path} build ${local.rm_arg} -t ${local.image_name} --build-arg cloud_user=${var.cloud_user} --build-arg cloud_group=${var.cloud_group} --build-arg cloud_uid=${var.cloud_uid} --build-arg cloud_gid=${var.cloud_gid} --build-arg cloud_shell=${var.cloud_shell} --build-arg docker_base_image=${var.docker_base_image} . )"
  }
}

resource "null_resource" "tag_image" {
  count     = var.container == "singularity" ? 0 : var.container == "host" ? 0 : var.disable_docker_image? 0 : 1
  depends_on = [null_resource.build_image]
  
  provisioner "local-exec" {
    command = "${var.docker_path} tag ${local.derived_image} ${local.registry_name} && ${var.docker_path} push ${local.registry_name}"
  } 
}

resource "null_resource" "key" {
  count = 0 
  provisioner "local-exec" {
    command = "${path.module}/install/check_key.sh ${var.project_public_key} ${var.cloud_user} ${var.customer}"
  }
}

resource "null_resource" "global-cache-container" {
  count  = var.global_cache? 0 : var.disable_global_cache? 0 : var.global_cache_server != "" ? 1 : 0 
  provisioner "local-exec" {
    command = "${path.module}/install/run_global_cache_container.sh '${var.global_cache_server}' ${var.cloud_user} ${var.cloud_group} ${var.cloud_uid} ${var.cloud_gid} '${var.registry_server}' ${var.container} ${local.container_name} '${var.singularity_path}' ${var.server_image} ${local.container_mount_path} '${var.docker_path}' ${var.terraformroot} ${var.rootless_docker} ${var.global_cache_pair}"
  }
}

resource "null_resource" "destroy_global-cache-container" {
  count  = var.global_cache? 0 : var.disable_global_cache? 0 : var.global_cache_server != "" ? 1 : 0 
  triggers = {
    customer = var.customer
    docker_path = var.docker_path
  }
  provisioner "local-exec" {
    when    = destroy
    command = "${self.triggers.docker_path} rm -f ${self.triggers.customer}-global-cache"
  }
}

/*
resource "null_resource" "destroy_image" {
  count     = var.container == "singularity" ? 0 : var.container == "host" ? 0 : var.disable_docker_image? 0 : 1
  triggers = {
    image_name = local.image_name
    docker_path = var.docker_path
  }
  provisioner "local-exec" {
    when    = destroy
    command = "${self.triggers.docker_path} rmi -f ${self.triggers.image_name}"
  }
}

resource "null_resource" "destroy_registry_image" {
  count     = var.container == "singularity" ? 0 : var.container == "host" ? 0 : var.disable_docker_image? 0 : 1
  triggers = {
    registry_name = local.registry_name
    docker_path = var.docker_path
  }
  provisioner "local-exec" {
    when    = destroy
    command = "${self.triggers.docker_path} rmi -f ${self.triggers.registry_name}"
  }
}
*/
