# Copyright © 2018-2023, Spillbox. All rights reserved.
# Property of Spillbox Inc.
# Any kind of copying or producing derivative work is prohibited without
# explicit written consent from Spillbox Inc.

variable "customer" {
  description = "customer or cluster name"
}

variable "mount_paths" {
  description = "List of NFS export path on prem"
}

variable "cache_dir" {
  description = "Directory where cached prem and generated cloud data reside"
}

variable "cloud_user" {
  description = "On prem unix username"
}

variable "cloud_group" {
  description = "On prem unix usergroup"
}

variable "cloud_uid" {
  description = "On prem unix user id"
}

variable "cloud_gid" {
  description = "On prem unix group id"
}

variable "ami_name" {
}

variable "docker_base_image" {
  type        = string
  description = "Docker base image"
}

variable "docker_rm" {
  type        = bool 
  description = "Remove docker after exit"
}

variable "docker_host" {
  description = "Docker server hostname"
}

variable "docker_port" {
  description = "Network port used by docker server"
}

variable "cloud_shell" {
  description = "Cloud SHell"
}

variable "disable_docker_image" {
  type        = bool 
  description = "Disable_building of docker_image"
}

variable "nameserver" {
  description = "Container DNS server"
}

variable "docker_registry_port" {
  description = "Docker registry port"
}

variable "docker_path" {
  description = "Unix path of docker binary"
}

variable "project_public_key" {
  description = "Public key file for compute machines"
}

variable "container" {}
variable "global_cache_pair" {}
variable "global_cache" {
  type = bool
}
variable "disable_global_cache" {
    type = bool
}
variable "global_cache_server" {}
variable "registry_server" {}
variable "singularity_path" {}
variable "terraformroot" {}
variable "rootless_docker" {}
variable "server_image" {}
variable "splfs_server" {}
variable "splfs_port" {}
variable "splfs_mountport" {}
variable "customer_project" {}
