#!/bin/bash -f

# Copyright © 2018-2023, Spillbox. All rights reserved.
# Property of Spillbox Inc.
# Any kind of copying or producing derivative work is prohibited without
# explicit written consent from Spillbox Inc.

#echo $@
#echo container:$1 container_name:$2 docker_path:$3 global_cache:$4

TIMEOUT=780
STEP=5
BASE=$(realpath $(dirname $0))
LOGFILE=$BASE/spillbox_splfs/LOG/conf.out
spillbox_config_file=$(realpath $BASE/../../../../etc/spillbox_config)
if [ -f  $spillbox_config_file ]; then
    . $spillbox_config_file
else
    echo missing config file : $spillbox_config_file >&2
    exit 1
fi

if [ "$4" = "true" ]; then
    export SPILLBOX_GLOBAL_CACHE=true
    job_manager=""
    job_submit_command=""
    job_kill_command=""
fi

echo "waiting $TIMEOUT seconds for NFS server"

if [ "$job_submit_command" != "" ]; then
    jobid=$($BASE/get_job_id.sh job_id)
    echo -n waiting
    $BASE/wait_for_jobid.sh $jobid
    RET=$?
    if [ $RET -ne 0 ]; then
        echo "NFS job Failed..."
        TIMEOUT=10
    fi
    stat_command=""
    success_string=""
    case  "$job_manager" in
        slurm)
            stat_command="squeue -l -j"
            success_string="RUNNING"
            ;;
        uge)
            stat_command="qstat -j"
            success_string="r"
            ;;
        lsf)
            stat_command="bjobs -l"
            success_string="RUN"
            ;;
        nc)
            stat_command="nc info"
            success_string="Running"
            ;;
        *)
            echo "Unsupported job manager $job_manager"  >& 2
            exit 3
            ;;
    esac
fi

echo -n waiting
tmp=0
while [ $TIMEOUT -gt $tmp ] ; do
    if [ -f $LOGFILE ]; then
        stat $LOGFILE 2>/dev/null
        break
    else
        echo -n .
        sleep $STEP
        tmp=`expr $tmp + $STEP`
    fi
    if [ "$job_submit_command" != "" ]; then
        job_status_grep=`$stat_command $jobid 2>&1 | grep -w $success_string 2<&1`
        if [ $? -ne 0 ]; then
            echo "NFS job failed...."
            break
        fi
    fi
done
echo
sleep 10

if [ ! -f $LOGFILE ]; then
    echo "NFS failed to come up" >&2
    if [ "$job_submit_command" != "" ]; then
        job_error=$($BASE/get_job_id.sh job_error)
        if [ "$job_error" == "" ]; then
            job_id=$($BASE/get_job_id.sh job_id )
            echo "Jobid: $job_id" >&2
        fi
    else
        if [ "$1" == "docker" ]; then
            taillog=$($3 logs $2 | tail -20)
            echo "" >&2
            echo "$taillog" >&2
            echo "" >&2
        fi
    fi
    if [ -f $BASE/spillbox_splfs/LOG/job_output ]; then
        tail -20 $BASE/spillbox_splfs/LOG/job_output | grep -v ^# >&2
    fi
    if [ -f $BASE/spillbox_splfs/LOG/LOG ]; then
        cat $BASE/spillbox_splfs/LOG/LOG  | grep -i crit >&2
    fi
    if [ -f $BASE/spillbox_splfs/LOG/LOG.STDOUT ]; then
        cat $BASE/spillbox_splfs/LOG/LOG.STDOUT  >&2
    fi
    exit 1
else
    echo "NFS server up"
fi
