#!/bin/bash -f

# Copyright © 2018-2025, Spillbox. All rights reserved.
# Property of Spillbox Inc.
# Any kind of copying or producing derivative work is prohibited without
# explicit written consent from Spillbox Inc.

# Exit if any of the intermediate steps fail
set -e

if [ "$#" -ne 1 ]; then
    echo "Incorrect Arguments" >& 2
    exit 1
fi 

BASE=$(realpath $(dirname $0))

# Determine which file to use based on the first argument
if [ "$1" == "true" ]; then
    HUB_INFO_FILE="${BASE}/spillbox_splfs/LOG/hub.out"
else
    HUB_INFO_FILE="${BASE}/spillbox_splfs/local_hub.out"
fi

# Check if the file exists
if [ ! -f "$HUB_INFO_FILE" ]; then
    echo "Error: File not found - $HUB_INFO_FILE" >&2
    exit 1
fi

# Extract "value" fields and format as JSON
grep -o '"[^"]*": {[^}]*"value": *"[^"]*"' "$HUB_INFO_FILE" | sed -E 's/"([^"]*)": *\{[^}]*"value": *"([^"]*)"/"\1": "\2"/' | awk 'BEGIN {print "{"} {print (NR==1 ? "" : ",") $0} END {print "}"}' 
