# Copyright © 2018-2023, Spillbox. All rights reserved.
# Property of Spillbox Inc.
# Any kind of copying or producing derivative work is prohibited without
# explicit written consent from Spillbox Inc.

locals {
  rm_arg         = var.docker_rm ? "--rm" : ""
  container_name = "${var.customer}-nfs-server"
  cwd            = abspath(path.module)
  cache_dir      = var.cache_dir == ""? var.container == "host"? "/dev/shm" : var.container == "singularity"? "/spillbox_cachedir" : "/spillbox_cachedir" : var.cache_dir
  container_mount_path = var.container_with_automount ? "${local.cwd}/install/spillbox_splfs" : var.container == "host"? "${local.cwd}/install/spillbox_splfs" : "/spillbox_splfs"
}

data "external" "host_ipaddress" {
  program    = ["${path.module}/install/get_host_ip.sh"]
}

data "external" "NFS_Port" {
  depends_on = [null_resource.check-nfs-container]
  program    = ["${path.module}/install/get_server_info.sh", "NFS_Port", "${var.terraformroot}"]
}

data "external" "MNT_Port" {
  depends_on = [null_resource.check-nfs-container]
  program    = ["${path.module}/install/get_server_info.sh", "MNT_Port", "${var.terraformroot}"]
}

#data "external" "Pid" {
#  depends_on = [null_resource.check-nfs-container]
#  program    = ["${path.module}/install/get_server_info.sh", "Pid", "${var.terraformroot}"]
#}


data "external" "IPaddress" {
  depends_on = [null_resource.check-nfs-container]
  program    = ["${path.module}/install/get_server_info.sh", "IPaddress", "${var.terraformroot}"]
}

data "external" "job_info" {
  depends_on = [null_resource.check-nfs-container]
  program    = ["${path.module}/install/get_job_id.sh", "-output", "${var.global_cache}"]
}

data "external" "hub_info" {
  depends_on = [null_resource.check-nfs-container]
  program    = ["${path.module}/install/hub_info.sh", "${var.spld_nfs_setup}"]
}

resource "null_resource" "pair-check" {
  triggers = {
    pair = var.pair
  }

  provisioner "local-exec" {
    command = "${path.module}/install/remove_job.sh '${local.container_name}' '${var.container}' '${var.rootless_docker}' '${var.docker_path}' '${var.global_cache}'"
  }
}

resource "null_resource" "run-nfs-container" {
  depends_on = [null_resource.pair-check]
  triggers = {
    pair = var.pair
  }
  provisioner "local-exec" {
    command = "${path.module}/install/run_container.sh '${split(":", var.server)[0]}' '${split(":", var.server)[1]}' '${local.cache_dir}' '${var.customer}' '${var.mount_paths}' '${var.cloud_user}' '${var.cloud_group}' '${var.cloud_uid}' '${var.cloud_gid}' '${var.vm_user}' '${var.cloud_provider}' '${var.admin_host}' '${var.cache_server}' '${var.nameserver}' '${var.nfs_portmin}' '${var.registry_server}' '${var.container}' '${var.cache_option}' '${local.container_name}' '${var.singularity_path}' '${var.server_image}' '${local.container_mount_path}' '${var.docker_path}' '${var.remote_repo_path}/' '${var.terraformroot}' '${var.patchelf_path}' '${var.max_ch_cap}' '${var.rootless_docker}' '${var.splfs_home}' '${var.archive}' '${var.disable_global_cache}' '${var.global_cache_server}' ${var.global_cache} '${var.nfs_model}' '${var.hybrid_mount_paths}' '${var.hybrid_mount_paths_exclude}' '${var.boostmode}' '${var.boost_server_cache_size}' '${var.boost_client_cache_dir}' '${var.hybrid_option}' '${var.wan_timeout}' '${self.triggers.pair}' '${var.global_cache_pair}' '${var.spld_nfs_setup}' '${var.home}' '${var.workdir}' '${var.container_path_remap}'"
  }
}

resource "null_resource" "check-nfs-container" {
  depends_on = [null_resource.run-nfs-container]
  triggers = {
    pair = var.pair
  }
  provisioner "local-exec" {
    command = "${path.module}/install/check_container.sh ${var.container} ${local.container_name} ${var.docker_path} ${var.global_cache}"
  }
}

resource "null_resource" "remove_job" {
  #depends_on = [null_resource.check-nfs-container]
  triggers = {
    customer = var.customer
    container_name = local.container_name
    path   = path.module
    container = var.container
    #mypid = lookup(data.external.Pid.result, "Pid")
    rootless_docker = var.rootless_docker
    docker_path     = var.docker_path
    global_cache    = var.global_cache
  }

  provisioner "local-exec" {
    when    = destroy
    command = "${self.triggers.path}/install/remove_job.sh ${self.triggers.container_name} ${self.triggers.container}  ${self.triggers.rootless_docker} '${self.triggers.docker_path}' ${self.triggers.global_cache}"
  }
}

resource "null_resource" "splfs_config_host_destroy" {
  count = var.job_manager == "" ? 1 : 0
  triggers = {
    customer = var.customer
    cache_dir = local.cache_dir
    cwd = local.cwd
    vm_user = var.vm_user
  }

  provisioner "local-exec" {
    when    = destroy
    command = "${self.triggers.cwd}/install/spillbox_splfs/uninstall_splfs.sh ${self.triggers.cache_dir} ${self.triggers.customer}"
  }
}

resource "null_resource" "docker_volume" {
  depends_on = [null_resource.check-nfs-container]
  provisioner "local-exec" {
    command = "${local.cwd}/install/install_volume.sh ${lookup(data.external.IPaddress.result, "IPaddress")} ${local.cache_dir} ${var.customer} ${var.mount_paths} ${lookup(data.external.NFS_Port.result, "NFS_Port")} ${lookup(data.external.MNT_Port.result, "MNT_Port")} ${var.terraformroot} ${var.cloud_user} ${var.cloud_group} ${var.cloud_uid} ${var.cloud_gid}  ${var.container} ${join(",",var.link_paths)}  '${var.workdir}'"
  }
}
