# Copyright © 2018-2023, Spillbox. All rights reserved.
# Property of Spillbox Inc.
# Any kind of copying or producing derivative work is prohibited without
# explicit written consent from Spillbox Inc.

output "container_name" {
  value = local.container_name
}

output "container_id" {
  value = local.container_name
}

output "splpipe_ipaddress" {
  value = lookup(data.external.host_ipaddress.result, "ipaddress")
}

output "splfs_ipaddress" {
  value = lookup(data.external.IPaddress.result, "IPaddress")
}

output "splfs_port" {
  value = lookup(data.external.NFS_Port.result, "NFS_Port")
}

output "splfs_mountport" {
  value = lookup(data.external.MNT_Port.result, "MNT_Port")
}

output "job_id" {
  value = lookup(data.external.job_info.result, "job_id")
}

output "job_error" {
  value = lookup(data.external.job_info.result, "job_error")
}

output "cache_dir" {
    value = local.cache_dir
}

output "hub_info" {
  value = lookup(data.external.hub_info.result, "server")
}

output "hub_pair" {
  value = lookup(data.external.hub_info.result, "pair")
}

output "hub_global_cache_server" {
  value = lookup(data.external.hub_info.result, "global_cache_server")
}

output "hub_global_cache_pair" {
  value = lookup(data.external.hub_info.result, "global_cache_pair")
}
