# Copyright © 2018-2023, Spillbox. All rights reserved.
# Property of Spillbox Inc.
# Any kind of copying or producing derivative work is prohibited without
# explicit written consent from Spillbox Inc.

variable "vm_user" {
  description = "OS VM user"
}

variable "cloud_provider" {
  description = "Cloud provider name"
}

variable "customer" {
  description = "customer or cluster name"
}

variable "mount_paths" {
  description = "List of NFS export path on prem"
}

variable "server" {
  description = "Hostname for splpipe hub server"
}

variable "hub_port_min" {
  description = "Socket Port used for prem as well as internal transport"
}

variable "nfs_portmin" {
  type        = number 
  description = "Starting socket Port used for NFS server"
}

variable "cache_dir" {
  description = "Directory where cached prem and generated cloud data reside"
}

variable "cache_server" {
  description = "File server which stores cached_data"
}

variable "cloud_user" {
  description = "On prem unix username"
}

variable "cloud_group" {
  description = "On prem unix usergroup"
}

variable "cloud_uid" {
  description = "On prem unix user id"
}

variable "cloud_gid" {
  description = "On prem unix group id"
}

variable "admin_host" {
  description = "Provide hostname of administrative machine"
}

variable "ami_name" {
}

variable "docker_rm" {
  type        = bool
  description = "Remove docker after exit"
}

variable "wan_timeout" {
  type        = number 
  description = "Designated host to create/destroy projects"
}

variable "nameserver" {
  description = "Container DNS server"
}

variable "sudo_access" {
  type        = bool
  description = "vm_user has sudo access" 
}

variable "registry_server" {
  description = "Customer existing registry server"
}

variable "server_image" {
  description = "Command server image name"
}

variable "cache_option" {
  description = "Docker option for cache_dir"
}

variable "terraformroot" {
  description = "Terraform source tree root"
}

variable "container_with_automount" {
  type        = bool 
  description = "Customer container mounts local file systems"
}

variable "docker_path" {
  description = "Path executable docker"
}

variable "singularity_path" {
  description = "Path executable singularity"
}

variable "remote_repo_path" {}
variable "container" {}
variable "patchelf_path" {}
variable "max_ch_cap" {
  type        = number
  description = "WAN throughput size"
}
variable "rootless_docker" {}
variable "splfs_home" {}
variable "archive" { type = bool }
variable "disable_global_cache" {
  type        = bool 
  description = "Disable global cache even if it exists"
}
variable "global_cache_server" {}
variable "global_cache" { type  = bool }

variable "link_paths" {
  type        = list
  description = "List of top level links on prem"
}
variable "job_manager" {
  description = "job_manager used to spawn nfs"
}
variable "nfs_model" {
  description = "Short name of Nfs server model to be deploy"
}
variable "hybrid_mount_paths" {} 
variable "hybrid_mount_paths_exclude" {}
variable "hybrid_option" {} 
variable "boostmode" {
  type        = bool 
  description = "EDABoost mode"
}
variable "boost_server_cache_size" {}
variable "boost_client_cache_dir" {}
variable "runtime_container" {}
variable "pair" {}
variable "global_cache_pair" {}
variable "spld_nfs_setup" {
  type        = bool
  description = "Spld Nfs Setup"
}
variable "home" {}
variable "spillbox_site" {}
variable "workdir" {}
variable "container_path_remap" {}
