terraform {
  required_version = ">= 1.10.4, < 1.10.5" 
  required_providers {
    aws = {
      version = "5.62.0"
    }
  }
}

variable "region" {}
variable "bucket_name" {}
provider "aws" {
  region        = var.region
}

resource "aws_s3_bucket" "tf_backend_bucket" {
  bucket        = var.bucket_name
  force_destroy = true

  tags = {
    ManagedByTerraform = "true"
    TerraformModule    = "terraform-aws-backend"
  }

  lifecycle {
    prevent_destroy = false
  }
}

