terraform {
  required_providers {
    azurerm = {
      version = "4.16.0"
    }
  }
}
provider "azurerm" {
  features {}
}

variable "resource_group" {
  description = "The name of the resource group"
}

variable "bucket_name" {
  description = "The name of the storage account bucket"
}

data "azurerm_resource_group" "tf_backend_bucket" {
  name = var.resource_group
}

resource "azurerm_storage_account" "tf_backend_bucket" {
  name                     = var.bucket_name
  resource_group_name      = data.azurerm_resource_group.tf_backend_bucket.name
  location                 = data.azurerm_resource_group.tf_backend_bucket.location
  account_tier             = "Standard"
  account_replication_type = "LRS"
}

