# Copyright © 2018-2023, Spillbox. All rights reserved.
# Property of Spillbox Inc.
# Any kind of copying or producing derivative work is prohibited without
# explicit written consent from Spillbox Inc.

variable "project" {
  description = "GCP project name"
}

variable "zone" {
  description = "GCP Zone"
}

variable "number" {
  description = "Number of controller to deploy"
}

variable "ami" {
  description = "EC2 AMI resource"
}

variable "key_name" {
  description = "AWA EC2 Key Pair"
}

variable "instance_type" {
  description = "EC2 instance resource"
}

variable "wait_time_vm" {
  description = "Wait time in second after VM up"
  default     = "15"
}

variable "subnet_id" {
  description = "VPC subnet id"
}

variable "subnet_id1" {
  description = "VPC subnet id"
  default     = "dummy"
}

variable "vpc_security_group_ids" {
  type        = list
  description = "List of EC2 instance VPC security group resource ids"
}

variable "Name" {
  description = "EC2 Name tag"
}

variable "public_key" {
  description = "Public SSH Key Pair pathname"
}

variable "local_ip" {
  description = "IP address of the local machine"
}

variable "model" {
  default = ""
}
