terraform {
  required_providers {
    google = {
        version = "6.16.0"
    }
  }
}
variable "project_id" {
  type = string
}

variable "region" {
  type = string
}

variable "google_credentials_file" {
  type = string
}

variable "bucket_name" {
  type = string
}

provider "google" {
  credentials = file(var.google_credentials_file)
  project     = var.project_id
  region      = var.region
}

resource "google_storage_bucket" "tf_backend_bucket" {
  name     = var.bucket_name 
  location = var.region
  force_destroy = true
}

output "bucket_name" {
  value = google_storage_bucket.tf_backend_bucket.name
}

