# Copyright © 2018-2023, Spillbox. All rights reserved.
# Property of Spillbox Inc.
# Any kind of copying or producing derivative work is prohibited without
# explicit written consent from Spillbox Inc.

terraform {
  required_version = ">= 1.10.4, < 1.10.5"
  required_providers {
    local = {
      version = "2.5.2"
    }
    null = {
      version = "3.2.3"
    }
  }
}

provider "local" {}

module "docker-compute" {
  source           = "../../../modules/docker-compute/"
  customer         = "${var.customer}-${var.customer_project}"
  ami_name         = var.ami_name
  mount_paths      = "${join(",", var.mount_paths)}"
  cloud_user       = var.cloud_user
  cloud_group      = var.cloud_group
  cloud_uid        = var.cloud_uid
  cloud_gid        = var.cloud_gid
  cache_dir        = var.cache_dir
  docker_rm        = var.docker_rm
  docker_host      = var.docker_host
  docker_port      = var.docker_port
  docker_base_image      = var.docker_base_image
  cloud_shell      = var.cloud_shell
  disable_docker_image      = var.disable_docker_image
  nameserver                = var.nameserver
  docker_registry_port      = var.docker_registry_port
  docker_path      = var.docker_path
  project_public_key = var.project_public_key
  container = var.runtime_container == "" ? var.container : var.runtime_container 
  registry_server    = var.registry_server
  singularity_path   = var.singularity_path
  terraformroot      = var.terraformroot
  rootless_docker    = var.rootless_docker
  server_image       = var.server_image
  splfs_server       = var.splfs_server
  splfs_port         = var.splfs_port
  splfs_mountport    = var.splfs_mountport
  customer_project   = var.customer_project
  global_cache_pair  = var.global_cache_pair
  global_cache       = var.global_cache
  disable_global_cache      = var.disable_global_cache
  global_cache_server       = var.global_cache_server
}
