# Copyright © 2018-2023, Spillbox. All rights reserved.
# Property of Spillbox Inc.
# Any kind of copying or producing derivative work is prohibited without
# explicit written consent from Spillbox Inc.

terraform {
  required_version = ">= 1.10.4, < 1.10.5"
  required_providers {
    external = {
      version = "2.3.4"
    }
    local = {
      version = "2.5.2"
    }
    null = {
      version = "3.2.3"
    }
  }
}

variable network {
    type    = map
    default = {
        "host"    = "host"
        "overlay" = "spillbox-overlay"
        "macvlan" = "spillbox-macvlan"
    }
}

provider "local" {}

module "docker-nfs" {
  source           = "../../../modules/docker-nfs/"
  cloud_provider   = var.cloud_provider
  customer         = "${var.customer}-${var.customer_project}"
  ami_name         = var.ami_name
  vm_user          = var.vm_user
  mount_paths      = "${join(",",var.mount_paths)}"
  cloud_user       = var.cloud_user
  cloud_group      = var.cloud_group
  cloud_uid        = var.cloud_uid
  cloud_gid        = var.cloud_gid
  hub_port_min     = var.hub_port_min
  nfs_portmin      = var.nfs_portmin
  cache_dir        = var.cache_dir
  cache_server     = var.cache_server
  admin_host       = var.admin_host
  server           = var.server
  docker_rm        = var.docker_rm
  docker_path      = var.docker_path
  singularity_path      = var.singularity_path
  wan_timeout      = var.wan_timeout
  nameserver       = var.nameserver
  sudo_access      = var.sudo_access
  registry_server  = var.registry_server  
  server_image     = var.server_image
  cache_option     = var.cache_option
  terraformroot    = var.terraformroot
  container_with_automount    = var.container_with_automount
  remote_repo_path      = var.remote_repo_path
  container        = var.container
  runtime_container = var.runtime_container
  patchelf_path    = var.patchelf_path
  max_ch_cap       = var.max_ch_cap
  rootless_docker  = var.rootless_docker
  splfs_home       = var.splfs_home
  archive          = var.archive
  disable_global_cache = var.disable_global_cache
  global_cache_server  = var.global_cache_server
  global_cache     = var.global_cache
  link_paths       = var.link_paths 
  job_manager      = var.job_manager
  nfs_model        = var.nfs_model
  hybrid_mount_paths            = var.hybrid_mount_paths
  hybrid_mount_paths_exclude    = var.hybrid_mount_paths_exclude
  hybrid_option                 = var.hybrid_option
  boostmode                     = var.boostmode 
  boost_server_cache_size       = var.boost_server_cache_size 
  boost_client_cache_dir        = var.boost_client_cache_dir 
  pair                          = var.pair 
  global_cache_pair             = var.global_cache_pair 
  spld_nfs_setup                = var.spld_nfs_setup
  home                          = var.home
  spillbox_site                 = var.spillbox_site
  workdir                       = var.workdir
  container_path_remap          = var.container_path_remap
}
