# Copyright © 2018-2023, Spillbox. All rights reserved.
# Property of Spillbox Inc.
# Any kind of copying or producing derivative work is prohibited without
# explicit written consent from Spillbox Inc.

output "container_name" {
  value = module.docker-nfs.container_name
}

output "container_id" {
  value = module.docker-nfs.container_id
}

output "splfs_server" {
  value = module.docker-nfs.splfs_ipaddress
}

output "splfs_public_ip" {
  value = module.docker-nfs.splfs_ipaddress
}

output "splfs_port" {
  value = module.docker-nfs.splfs_port
}

output "splfs_mountport" {
  value = module.docker-nfs.splfs_mountport
}

output "server" {
  value = var.spld_nfs_setup ? module.docker-nfs.hub_info : var.server
}

output "qserver" {
  value = var.spld_nfs_setup ? module.docker-nfs.hub_info : var.server
}

output "tunnel_server" {
  value = module.docker-nfs.splpipe_ipaddress
}

output "customer" {
  value = var.customer
}

output "customer_id" {
  value = var.customer
}

output "cache_dir" {
  value = module.docker-nfs.cache_dir
}

output "cloud_provider" {
  value = var.cloud_provider
}

output "customer_project" {
  value = var.customer_project
}

output "cloud_uid" {
  value = var.cloud_uid
}

output "cloud_gid" {
  value = var.cloud_gid
}

output "job_route_id" {
  value = "local"
}

output "vm_user" {
  value = var.vm_user
}

output "mount_paths" {
  value = "${flatten(var.mount_paths)}"
}

output "link_paths" {
  value = "${flatten(var.link_paths)}"
}

output "region" {
  value = ""
}

output "terraformroot" {
    value =  var.terraformroot
}

output "client_hosts" {
    value =  var.client_hosts
}

output "nameserver" {
    value =  var.nameserver
}

output "docker_wrapper" {
  value = var.docker_wrapper
}

output "registry_server" {
  value = var.registry_server 
}

output "server_image" {
  value = var.server_image 
}

output "job_id" {
  value = module.docker-nfs.job_id
}

output "job_error" {
  value = module.docker-nfs.job_error
}

output "remote_repo_path" {
  value = var.remote_repo_path
}

output "container" {
  value = var.container
}

output "max_ch_cap" {
  value = var.max_ch_cap
}

output "cloud_ssh_port" {
  value = var.cloud_ssh_port
}
output "nfs_model" {
  value = var.nfs_model
}
output "hybrid_mount_paths" {
  value = var.hybrid_mount_paths
}

output "hybrid_mount_paths_exclude" {
  value = var.hybrid_mount_paths_exclude
}
output "hybrid_option" {
  value = var.hybrid_option
}
output "runtime_container" {
  value = var.runtime_container
}
output "spld_nfs_setup" {
  value = var.spld_nfs_setup
}
output "pair" {
  value = module.docker-nfs.hub_pair
}
output "global_cache_server" {
  value = module.docker-nfs.hub_global_cache_server
}
output "global_cache_pair" {
  value = module.docker-nfs.hub_global_cache_pair
}
output "spillbox_site" {
  value = var.spillbox_site
}
output "workdir" {
  value = var.workdir
}
output "container_path_remap" {
  value = var.container_path_remap
}
