# Copyright © 2018-2023, Spillbox. All rights reserved.
# Property of Spillbox Inc.
# Any kind of copying or producing derivative work is prohibited without
# explicit written consent from Spillbox Inc.

variable "vm_user" {
  description = "OS VM user"
}

variable "cloud_provider" {
  description = "Cloud provider name"
}

variable "customer" {
  description = "customer or cluster name"
}

variable "mount_paths" {
  type        = list
  description = "List of NFS export path on prem"
}

variable "link_paths" {
  type        = list
  description = "List of top level links on prem"
}

variable "server" {
  description = "Socket Port used for prem as well as internal transport"
  default = "dummyser:dummyport"
}

variable "cache_dir" {
  description = "Directory where cached prem and generated cloud data reside"
}

variable "cache_server" {
  description = "File server which stores cache data"
}

variable "cloud_user" {
  description = "On prem unix username"
}

variable "cloud_group" {
  description = "On prem unix usergroup"
}

variable "cloud_uid" {
  description = "On prem unix user id"
}

variable "cloud_gid" {
  description = "On prem unix group id"
}

variable "customer_project" {
  description = "Customer project name"
}

variable "admin_host" {
  description = "Provide hostname of administrative machine"
}

variable "docker_rm" {
  type        = bool 
  description = "Remove docker after exit"
}

variable "ami_name" {}

variable "terraformroot" {
  description = "Terraform source tree root"
}

variable "client_hosts" {
  description = "Designated host to create/destroy projects"
}

variable "wan_timeout" {
  type        = number 
  description = "Designated host to create/destroy projects"
}

variable "max_ch_cap" {
  type        = number 
  description = "WAN throughput size"
}

variable "hub_port_min" {
  type        = number 
  description = "Socket Port used for prem as well as internal transport"
}

variable "nfs_portmin" {
  type        = number 
  description = "Starting socket Port used for NFS server"
}

variable "nameserver" {
  description = "Container DNS server"
}

variable "docker_wrapper" {
  description = "Full path of docker wrappers"
}

variable "sudo_access" {
  type        = bool
  description = "vm_user has sudo access" 
}

variable "registry_server" {
  description = "Customer existing registry server"
}

variable "server_image" {
  description = "Command server image name"
}

variable "cache_option" {
  description = "Docker option for cache_dir"
}

variable "container_with_automount" {
  type        = bool 
  description = "Customer container mounts local file systems"
}

variable "docker_path" {
  description = "Unix path of docker binary"
}

variable "singularity_path" {
  description = "Unix path of singularity binary"
}

variable "remote_repo_path" {}

variable "container" {}
variable "patchelf_path" {}
variable "rootless_docker" {}
variable "splfs_home" {}
variable "archive" { type = bool }
variable "disable_global_cache" {
  type        = bool 
  description = "Disable global cache even if it exists"
}
variable "global_cache_server" {}
variable "global_cache" { type  = bool }
variable "job_manager" {
  description = "job_manager used to spawn nfs"
}
variable "cloud_ssh_port" {}
variable "nfs_model" {}
variable "hybrid_mount_paths" {}
variable "hybrid_mount_paths_exclude" {}
variable "hybrid_option" {}
variable "boostmode" {
  type        = bool 
  description = "EDABoost mode"
}
variable "boost_server_cache_size" {}
variable "boost_client_cache_dir" {}
variable "runtime_container" {}
variable "pair" {}
variable "global_cache_pair" {}
variable "spld_nfs_setup" {
  type        = bool
  description = "Spld Nfs Setup"
}
variable "home" {}
variable "spillbox_site" {}
variable "workdir" {}
variable "container_path_remap" {}
