#!/bin/bash -f

# Copyright © 2018-2023, Spillbox. All rights reserved.
# Property of Spillbox Inc.
# Any kind of copying or producing derivative work is prohibited without
# explicit written consent from Spillbox Inc.

# Wrapper Script for Executing Terraform
#

usage()
{
    echo "Usage : $0 aws|google|azure|local   vars|config|init|apply|destroycluster|destroyinfra|output|snapshot|backup|restore|upload|check|checklimit|image|hub|predictivecache <customer>  <project_name> [[-vars|-system|-user|-override|-ssh_public|-ssh_private|-logfile] [<terraform_tfvar_file>|<ssh_public_key_file>|<ssh_private_key_file>|<spillbox_file_log>]]|<output_variable>|[<-keepcache|-rmcache>] [[-cachesize] [cachesizevalue]]"  >&2
}

checkcloudkeyprovider()
{
    if [ "$TF_VAR_cloudkeyprovider" != "spillbox" ]; then
        return
    fi
    if [ "$1" == "" ]; then
        return
    fi
    if [ ! -d "$1" ]; then
        return
    fi
    count=$(ls -d /${1}/*/ | wc -l)
    if test $count -gt 1; then
        echo "Number of projects using Spillbox key exceeded the limit." >&2
        exit 3
    fi
}

if test "$#" -lt 4; then
    usage;
    exit 3
fi

if echo "$4" | grep -q "\.\."; then
    echo "Project name contains .. which is not allowed." >&2
    exit 3
else
    if   echo "$4" | grep -q "/"; then
        echo "Project name contains / character which is not allowed." >&2
        exit 3
    fi
fi


DIR="$( cd "$( dirname "${BASH_SOURCE[0]}" )" >/dev/null 2>&1 && pwd )"
export TERRAFORM_ROOT=$DIR
SPLD_NFS_SETUP=false

if [ "$TF_VAR_vpn_container" == "true" ] ; then
    LOGDIR="$HOME"
    if [ -f  $DIR/etc/spillbox_config ]; then
        tmp=$(grep workdir $DIR/etc/spillbox_config | grep -v ^# | awk -F= '{print $2}' | sed -e 's/^"//' -e 's/"$//' | sed 's/ //g')
        if [ "$tmp" != "" ]; then
            LOGDIR="$tmp"
        else
            echo "workdir not set in $DIR/etc/spillbox_config" >&2
            exit 3
        fi
        tmp=$(grep ^spld_nfs_setup $DIR/etc/spillbox_config | grep -v ^# | awk -F= '{print $2}' | sed -e 's/^"//' -e 's/"$//' | sed 's/ //g')
        if [ "$tmp" != "" ]; then
            SPLD_NFS_SETUP="$tmp"
        fi
    fi
    WDIR="$LOGDIR/.spillbox/customers/$3/$4-$SPILLBOX_SITE"
else
    WDIR="${DIR}/../customers/$3/$4"
fi

case "$2" in
  check)
        if [ "$1" == "local" ]; then
            if [ ! -d "$WDIR" ]; then
                echo "Init missing. Please run destroy_all." >&2
                exit 3
            fi 
        fi
        exit 0
        ;;
  checklimit)
        if [ "$1" != "local" ]; then
            checkcloudkeyprovider $WDIR
        fi
        exit 0
        ;;
  config)
      #if [ ! -d "$WDIR" ]; then
          if [ -f $WDIR/TO_BE_DELETED ]; then
              /bin/rm -rf $WDIR 
          fi
          mkdir -p $WDIR
          if [ ! -d "$WDIR" ]; then
              echo "Directory $WDIR could not be created" >&2
              exit 3
          fi
          mkdir -p $DIR/logs/  
          EXCLUDE= 
          if [ "$1" == "local" ]; then
            EXCLUDE="--exclude=vars/ -exclude=uge/ -exclude=rtda/ -exclude=lsf/ -exclude=slurm/ -exclude=build_scripts/ -exclude=build/" 
          fi 
          /usr/bin/rsync -az $EXCLUDE --exclude='terraform.tfstate' --exclude='terraform.tfstate.backup' --exclude='terraform.tfstate.backup' --exclude=logs/ --exclude=junk/ --exclude='.terraform' --exclude=grid_orchestration/ --exclude=utils/ --exclude=build_scripts/ --exclude=plugin/ $DIR/ $WDIR/ |& tee $DIR/logs/log.rsync
          exit_status=${PIPESTATUS[0]}
          if [ $exit_status != 0 ]; then
              echo "rsync failed" >&2
              exit $exit_status
          fi
          ( cd $WDIR ; mkdir -p vars logs junk spooldir ; chmod 755 spooldir)
          ( cd $WDIR/vars ; mkdir -p $1; echo "{ \"foo\": \"bar\" }" > $1/terraform.x.auto.tfvars.json)
      #fi
      ;;
  vars)
      #if [ ! -d "$WDIR" ]; then
          mkdir -p $WDIR
          if [ ! -d "$WDIR" ]; then
              echo "Directory $WDIR could not be created" >&2
              exit 3
          fi
          mkdir -p $DIR/logs/  
          ( cd $WDIR ; mkdir -p vars logs junk )
          $DIR/terraform_config.sh $@  |& tee -a  $DIR/logs/log.vars
          exit 0 
      #fi
      ;;
  init|apply|destroycluster|destroyinfra|output)
          if [ ! -d "$WDIR" ]; then
              echo "Internal Error: Directory $WDIR does not exist." >&2
              exit 3
          fi
      ;;
  snapshot)
          if [ ! -d "$WDIR" ]; then
              ( cd  $DIR ; export TERRAFORM_ROOT=$DIR; mkdir -p $DIR/logs ; ./terraform_snapshot.sh $@ |& tee $DIR/logs/log.last ; exit ${PIPESTATUS[0]} )
          else
              ( cd  $WDIR ; export TERRAFORM_ROOT=$WDIR ; mkdir -p $WDIR/logs ; ./terraform_snapshot.sh $@ |& tee $WDIR/logs/log.last ; exit ${PIPESTATUS[0]} )
          fi
          exit_status=${PIPESTATUS[0]}
          exit $exit_status
      ;;
  backup)
          if [ ! -d "$WDIR" ]; then
              echo "Internal Error: Directory $WDIR does not exist." >&2
              exit 3
          fi
          ( cd  $WDIR ; export TERRAFORM_ROOT=$WDIR ; mkdir -p $WDIR/logs ; ./terraform_backup.sh $@ |& tee $WDIR/logs/log.last; exit ${PIPESTATUS[0]} )
          exit_status=${PIPESTATUS[0]}
          exit $exit_status
      ;;
  predictivecache)
            if [ ! -d "$WDIR" ]; then
                echo "Internal Error: Directory $WDIR does not exist." >&2
                exit 3
            fi
            if [ "$1" != "local" ]; then
                    cp -r $DIR/predictivecache $WDIR/
            fi
           touch $WDIR/PREDICTIVE_ENABLED
           ( cd  $WDIR ; export TERRAFORM_ROOT=$WDIR ; mkdir -p $WDIR/logs ; ./predictivecache/start_predictive.sh $@ |& tee $WDIR/logs/log.last; exit ${PIPESTATUS[0]})
           exit_status=${PIPESTATUS[0]}
           exit $exit_status
      ;;
  restore)
          if [ ! -d "$WDIR" ]; then
              echo "Internal Error: Directory $WDIR does not exist." >&2
              exit 3
          fi
          ( cd  $WDIR ; export TERRAFORM_ROOT=$WDIR ; mkdir -p $WDIR/logs ; ./terraform_restore.sh $@ |& tee $WDIR/logs/log.last ; exit ${PIPESTATUS[0]} )
          exit_status=${PIPESTATUS[0]}
          exit $exit_status
      ;;
  upload)
          if [ ! -d "$WDIR" ]; then
              ( cd  $DIR ; export TERRAFORM_ROOT=$DIR ; mkdir -p $DIR/logs ; ./terraform_upload.sh "$@" |& tee $DIR/logs/log.last ; exit ${PIPESTATUS[0]} )
          else
              ( cd  $WDIR ; export TERRAFORM_ROOT=$WDIR ; mkdir -p $WDIR/logs ; ./terraform_upload.sh "$@" |& tee $WDIR/logs/log.last ; exit ${PIPESTATUS[0]} )
          fi 
          exit_status=${PIPESTATUS[0]}
          exit $exit_status
      ;;
  image)
        cd  $DIR ; export TERRAFORM_ROOT=$DIR ; mkdir -p $DIR/logs ; ./server_image.sh output |& tee $DIR/logs/log.last ; exit ${PIPESTATUS[0]} 
        exit_status=${PIPESTATUS[0]}
        exit $exit_status
        ;;
  hub)
        if [ "$SPLD_NFS_SETUP" != "true" ]; then
            export SPILLBOX_CLOUD_USER=$3 ; $DIR/hub.sh $4 $5 $6 $7
            #export SPILLBOX_CLOUD_USER=$3 ; $DIR/hub.sh $4 $5 $6 $7 > $WDIR/stacks/modules/docker-nfs/install/spillbox_splfs/local_hub.out
            exit $?
        fi
        ;;
  *)
      usage;
      exit 3
      ;;
esac

if [[ "$2" == "destroycluster" && "$1" == "local" && -f $WDIR/PREDICTIVE_ENABLED ]]; then
    ( cd  $WDIR ; export TERRAFORM_ROOT=$WDIR ; mkdir -p $WDIR/logs ; ./predictivecache/start_predictive.sh $@ |& tee $WDIR/logs/log.last; exit ${PIPESTATUS[0]})
fi
( cd  $WDIR ; export TERRAFORM_ROOT=$WDIR; mkdir -p $WDIR/logs ; ./terraform_command.sh $@ )
exit_status=$?
if [ $2 == "destroyinfra" ]; then
  if [ $exit_status == 0 ]; then
    mkdir -p $DIR/junk
    if [ "$TF_VAR_vpn_container" == "true" ] ; then
	    JUNK_DIR="${DIR}/junk/${3}.${4}.${SPILLBOX_SITE}.DELETE.$$"
	    mv $WDIR $JUNK_DIR
    else
	    JUNK_DIR="${DIR}/junk/${3}.${4}.DELETE.$$"
	    mv $WDIR $JUNK_DIR
    fi
    if [ "$1" == "azure" ]; then
        if [ -d "$WDIR" ]; then
            /bin/rm -rf $WDIR 
        fi
    fi
    if [ "$6" == "-rmworkdir" ] ; then
	    if [ -d "${JUNK_DIR}" ]; then
		    /bin/rm -rf ${JUNK_DIR} &> /dev/null
        fi
    fi
  else
    touch $WDIR/TO_BE_DELETED
    #/bin/rm -f $WDIR/stacks/provider/$1/splfs/terraform.tfstate $WDIR/stacks/provider/$1/spillbox-cluster/terraform.tfstate $WDIR/stacks/provider/$1/ssh_key_pair/terraform.tfstate $WDIR/stacks/provider/$1/resource_group/terraform.tfstate $WDIR/stacks/provider/$1/project/terraform.tfstate 
  fi
fi
exit $exit_status
