#!/bin/bash -f

# Copyright © 2018-2023, Spillbox. All rights reserved.
# Property of Spillbox Inc.
# Any kind of copying or producing derivative work is prohibited without
# explicit written consent from Spillbox Inc.

saved_args=$@
usage()
{
	echo Arguments: $saved_args
	echo "Usage        : $0 <local> <all|username>"
}

if test "$#" -ne 2 ; then
	usage;
	exit 3
fi

if [ "local" != "$1" ]; then
	 usage;
        exit 3
fi

case "$2" in
  all)
	spldpro=spld.hub
	;;
  *)	
	spldpro=spld.hub.$2
	;;
esac

hub=$(pgrep -f "$spldpro")
if [[ $hub == "" ]]; then
	echo "No Projects are running right now"
else
	echo --------------------------------------------------------------------------------------------------- 
fi 

for spld in $hub
do 
	job_id=0 
	job_manager="";
	job_state="";
	job_exechost="";
	status="not running";
	spldproj=$(ps aux | grep -w $spld | grep -v grep | awk '{print $13}' )
	USER=$(echo $spldproj | awk -F "sites/local/hub/" '{print $2}' | awk -F '/' '{print $1}')
    PROJECTNAME=$(echo "$spldproj" | awk -F "sites/local/hub/$USER" '{print $2}' | awk -F - '{print $1}' | sed 's|^/||')
	LOGDIR=$(echo $spldproj | awk -F '/.spillbox' '{print $1}')
	if [ -f $spldproj ]; then
		site_tag=$(cat $spldproj | awk -F '"' '/^siteid/ {print $2}')
		site_port=$(cat $LOGDIR/.spillbox/sites/$1/$site_tag/portlog)
		WDIR="$LOGDIR/.spillbox/customers"
		PROJ_WDIR="$WDIR/$USER/$PROJECTNAME-$site_tag"
        else
		WDIR="$LOGDIR/.spillbox/customers"
                PROJ_WDIR="$WDIR/$USER/$PROJECTNAME-$site_tag"
                site_port="Not known"
		site_tag="Not known"  
		
        fi
	if [ -d $PROJ_WDIR ]; then
                 work_dir=true
        fi
	if [ -f  $PROJ_WDIR/etc/spillbox_config ] ; then
		. $PROJ_WDIR/etc/spillbox_config	
	else
		echo "USER               : $USER"
                echo "PROJECT-NAME       : $PROJECTNAME"
		echo "PROJECT_SERVER     : `hostname -f | awk '{print $1}'`:$site_port ( SITE_TAG : $site_tag)"
		if ! [ "$work_dir" == true ]; then
			echo "    ERROR : $PROJ_WDIR directory is not present"
		fi
		echo  "    ERROR : $PROJ_WDIR/etc/spillbox_config file is not present "
		echo  " ( POSSIBILITY : Project CREATE in progress / Project DESTROY was unsucessfull)"
                echo ---------------------------------------------------------------------------------------------------
		continue
	fi
 	cli_hostname=$(grep client_hostname $PROJ_WDIR/vars/local/terraform.u.auto.tfvars.json | awk '{print $2}' | sed s/\"//g | sed s/,//g)	
        if [[ "$job_manager" == "uge" || "$job_manager" == "lsf" ]] ; then
		if [[ "$job_manager" == "uge" ]]; then
			job_id=`cat $PROJ_WDIR/stacks/modules/docker-nfs/install/spillbox_splfs/LOG/job_output | awk '{print $3}'`
		fi
		if [[ "$job_manager" == "lsf" ]] ; then
			job_id=`cat $PROJ_WDIR/stacks/modules/docker-nfs/install/spillbox_splfs/LOG/job_output | awk '{print $2}' | sed 's/<//g' |sed 's/>//g' `
		fi 
                if [[  $job_id =~ ^[0-9]+$ ]]; then
			. $user_setup_file
			if [[ "$job_manager" == "uge" ]]; then
				job_state="`qstat -j $job_id | awk /^job_state/ | awk '{print $3}'`" 
				job_exechost=`qstat -j $job_id | awk /^exec_host_list/ | awk '{print $3}'`
			fi
			if [[ "$job_manager" == "lsf" ]]; then
				job_state=`bjobs -w  $job_id | awk /^$job_id/ | awk '{print $3}'` 
				job_exechost=`bjobs -w  $job_id | awk /^$job_id/ | awk '{print $6}'`
			fi
		else
			echo "   ERROR : Cannot find the job id in $PROJ_WDIR/stacks/modules/docker-nfs/install/spillbox_splfs/LOG/job_output"
			job_id="Not known"
			job_state="Not known"
			job_exechost="Not known"
			status="Not known"
		fi
	else
		if [[ "$container" == "host" ]]; then
			proc=`cat $cache_dir/$USER-$PROJECTNAME/cache_dir/pid`
			proces=`ps aux | grep -v grep | grep -w $proc`
			if [ ${#proces} -ne 0 ]; then
				status="running "
				status+="(PID : $proc)"
			fi
		elif [[ "$container" == "docker" ]]; then
			dock_path=`which docker`
			cont=`$dock_path ps -a | grep Up | grep "$USER-$PROJECTNAME-nfs-server"`
			#ret=$?
			#if [ $ret -ne 0 ]; thne 
			#	continue
			#fi
			if [ ${#cont} -ne 0 ]; then
				id=`$dock_path ps -a | grep Up | grep "$USER-$PROJECTNAME-nfs-server" | awk '{print $1}'`
				status="running "
				status+="(ID : $id)"
			fi
		fi
		job_exechost=`hostname -s`
	fi
####################################################################################
	echo "USER               : $USER"
	echo "PROJECT-NAME       : $PROJECTNAME"
	echo "PROJECT_SERVER     : `hostname -f | awk '{print $1}'`:$site_port ( SITE_TAG : $site_tag)"
	if [[ "$site_tag" == "Not known" ]]; then
		echo "    ERROR: $spldproj file is not present "
	fi
	echo "CLIENT HOSTNAME    : $cli_hostname"
	echo "PROJECT_CACHEDIR   : $cache_dir/$USER-$PROJECTNAME"
	if [ "$work_dir" == "true" ]; then
		echo "PROJECT_WORKDIR    : $PROJ_WDIR"		
	fi
	echo "SPLD_PROJSERVER    : Running on PID $spld (` ps aux | grep -v grep | grep -w "$spld" | awk '{print $11}'`) "
	if [[ "$job_manager" == "uge" || "$job_manager" == "lsf" ]] ; then
		echo "JOB_MANAGER        : $job_manager"
		echo "JOB_ID             : $job_id  "
		echo "JOB_STATE          : $job_state "
	else
		echo "JOB_MANAGER        :  No job_manager "	
	fi
	if [[ "$job_manager" == "uge" && "$job_state" == "r" ]]; then
		status="running"
	fi
	if [[ "$job_manager" == "lsf" && "$job_state" == "RUN" ]]; then
                status="running"
        fi
	echo " SPLFS server is $status on the $container ..... Exec_Host :$job_exechost"
	echo ---------------------------------------------------------------------------------------------------
done
