# Copyright © 2018-2023, Spillbox. All rights reserved.
# Property of Spillbox Inc.
# Any kind of copying or producing derivative work is prohibited without
# explicit written consent from Spillbox Inc.

terraform {
  required_version = ">= 1.10.4, < 1.10.5" 
}

variable "customer" {
  description = "Customer or cluster name"
}

variable "customer_project" {
  description = "Customer project name"
}

variable "dirs" {
  description = "Directories to be uploaded/pre-cached , separated by ,"
}

variable "filter" {
  description = "Filter"
}

variable "docker_image" {
  description = "Docker image"
}

variable "docker_host" {
  description = "Docker host"
}

variable "docker_port" {
  description = "Docker port"
}

variable "cloud_user" {
  description = "On prem unix username"
}

variable "cloud_group" {
  description = "On prem unix groupname"
}

variable "cloud_uid" {
  description = "On prem unix uid"
}

variable "cloud_gid" {
  description = "On prem unix gid"
}

variable "mount_paths" {
  description = "List of NFS export path on prem"
}

variable "cache_dir" {
  description = "Directory where cached prem and generated cloud data reside"
}

variable "splfs_server" {
  description = "Hostname for proxy ( or local) file server" 
}

variable "local_meta_only" {
  type = bool 
  description = "Sync local metadata only" 
}

variable "splfs_port" {
  description = "File server NFS port" 
}

variable "splfs_mountport" {
  description = "File server mount port" 
}

variable "container" {}
variable "docker_path" {}
variable "singularity_path" {}
variable "singularity_base_image" {}
variable "rootless_docker" {}

resource "null_resource" "upload" {
    provisioner "local-exec" {
        command = "${path.module}/install/upload.sh '${var.dirs}' '${var.filter}' '${var.docker_image}' '${var.docker_host}' '${var.docker_port}' '${var.customer_project}' '${var.customer}' '${var.mount_paths}' '${var.cache_dir}' '${var.splfs_server}' '${var.cloud_uid}' '${var.cloud_gid}' '${var.local_meta_only}' '${var.splfs_port}' '${var.splfs_mountport}' '${var.cloud_user}' '${var.cloud_group}' '${var.container}' '${var.docker_path}' '${var.singularity_path}' '${var.rootless_docker}' '${var.singularity_base_image}'"
   }
}
