variable "docker_ami_id" {
  description = "The ID of the Amazon Machine Image (AMI)."
}
variable "snapshot_id" {
  description = "The ID of the snapshot."
}
variable "image_root_volume_size" {
  description = "The size of the volume in GB."
}
variable "subnet_id" {
  description = "The ID of the subnet in which the instance is launched."
}
variable "vpc_id" {
  description = "The ID of the VPC."
}
variable "security_group_id" {
  description = "The ID of the security group."
}
variable "region" {
  description = "The AWS region to deploy resources in."
}
variable "image_instance_type" {
  description = "Instance type for the EC2 instance"
  default     = "t2.medium"
}
variable "cloud_ssh_port" {
  description = "The SSH port for the instance"
  type        = number
  default     = 22
}
variable "market_place" {
  type        = number
}
variable "ami_user" {}
variable "kms_key_id" {}
variable "imagetag" {}
variable "key_name" {}
variable "secrets" {}
variable "webserverip" {}
variable "service_userid" {}
