terraform {
  required_version = ">= 1.10.4, < 1.10.5"
  required_providers {
    aws = {
      version = "5.89.0"
    }
    null = {
      version = "3.2.3"
    }
  }
}
provider "aws" {
  region = var.region
}

locals {
  key_name = "${var.imagetag}-auto-key"
  private_key_filename = format("%s/%s.pem", var.secrets, local.key_name)
}

resource "aws_instance" "host_image" {
  ami                    = var.docker_ami_id
  instance_type          = var.image_instance_type
  subnet_id              = var.subnet_id
  vpc_security_group_ids = [var.securitygroup_id]
  key_name               = var.key_name
  root_block_device {
    volume_size           = var.image_root_volume_size
    kms_key_id            = var.kms_key_id == "" ? null : var.kms_key_id
    encrypted             = var.kms_key_id == "" ? false : true
    delete_on_termination = true
  }
  tags = {
    Name = ("spillbox-${var.imagetag}-hostimage")
  }
  provisioner "local-exec" {
    command = "sleep 60 && echo done waiting master VM ready"
  }
}

resource "null_resource" "build_host_image" {
  depends_on = [aws_instance.host_image]
  connection {
    user        = var.ami_user
    private_key = file(local.private_key_filename)
    host        = element(flatten(aws_instance.host_image.*.private_ip), 0)
    port        = var.cloud_ssh_port
    timeout     = "300s"
  }

  provisioner "file" {
   source      = "${path.module}/../../../install"
   destination = "/tmp"
  }

  provisioner "file" {
   source      = "${path.module}/install"
   destination = "/tmp"
  }

  provisioner "remote-exec" {
    inline = [ "chmod 755 /tmp/install/install.sh ; /tmp/install/install.sh '${var.repo_dir}' '${var.gpg_dir}'"]
  }
}
