variable "region" {
  description = "The AWS region to deploy resources in."
}
variable "cloud_ssh_port" {}
variable "imagetag" {
  description = "Image Tag name"
}
variable "secrets" {
  type        = string
  description = "Path to SSH public key directory (e.g. `/secrets`)"
}
variable "docker_ami_id" {
  description = "The ID of the Amazon Machine Image (AMI)."
}
variable "image_root_volume_size" {
  description = "The size of the volume in GB."
}
variable "subnet_id" {
  description = "The ID of the subnet in which the instance is launched."
}
variable "vpc_id" {
  description = "The ID of the VPC."
}
variable "securitygroup_id" {
  description = "The ID of the security group."
}
variable "image_instance_type" {
  description = "Instance type for the EC2 instance"
  default     = "t2.medium"
}
variable "ami_user" {}
variable "kms_key_id" {}
variable "key_name" {}
variable "repo_dir" {}
variable "gpg_dir" {}
