terraform {
  required_version = ">= 1.10.4, < 1.10.5"
  required_providers {
    aws = {
      version = "5.89.0"
    }
    local = {
       version = "2.5.2"
    }
    null = {
      version = "3.2.3"
    }
    tls = {
      version = "4.0.6"
    }
  }
}

provider "aws" {
  region = var.region
}
locals {
  key_name = "${var.imagetag}-auto-key"
  public_key_filename = format("%s/%s.pub", var.secrets, local.key_name)
  private_key_filename = format("%s/%s.pem", var.secrets, local.key_name)
  kms_key_id = ""
}

resource "tls_private_key" "default" {
  algorithm = "RSA"
  rsa_bits  = 4096
}
#creating a ssh-key pair
resource "local_file" "public_key_openssh" {
  depends_on           = [tls_private_key.default]
  sensitive_content    = tls_private_key.default.public_key_openssh
  filename             = local.public_key_filename
  file_permission      = "0600"
  directory_permission = "0700"
}

resource "local_file" "private_key_pem" {
  depends_on           = [tls_private_key.default]
  sensitive_content    = tls_private_key.default.private_key_pem
  filename             = local.private_key_filename
  file_permission      = "0600"
  directory_permission = "0700"
}

resource "null_resource" "chmod" {
  depends_on = [local_file.private_key_pem]

  triggers = {
    local_file_private_key_pem = local_file.private_key_pem.filename
  }

  provisioner "local-exec" {
    command = format(var.chmod_command, local.private_key_filename)
  }
}

resource "aws_key_pair" "import" {
 depends_on           = [local_file.public_key_openssh]
  key_name_prefix = local.key_name
  public_key      = join("", tls_private_key.default.*.public_key_openssh)
}
